#include <stdio.h>
 #include <list>
 
 #define MAX(X,Y) ((X) > (Y) ? (X) : (Y))
 #define MIN(X,Y) ((X) < (Y) ? (X) : (Y))
 #define ABS(X) ((X) < 0 ? -(X) : (X))
 
 using namespace std;
 
 class Group {
 	public:
 		double l, h;
 		double t;
 		Group(double rad, long long int cen, long long int num) {
 			l = cen - rad * num;
 			h = cen + rad * num;
 			t = rad * (num - 1);
 		}
 
 		void merge(Group* other);
 };
 
 void Group::merge(Group* other) {
 	double diff = MIN(h, other->h) - MAX(l, other->l);
 	if (diff == h - l || diff == other->h - other->l) {
 		diff += MIN(ABS(h - other->h), ABS(l - other->l));
 	}
 	double tdiff = (other->t - t);
 	if (ABS(tdiff) > diff) {
 		if (tdiff < 0) {
 			other->t += diff;
 			h += diff;
 		} else {
 			t += diff;
 			l -= diff;
 		}
 		tdiff -= diff;
 		diff = 0;
 	} else {
 		diff -= ABS(tdiff);
 		if (tdiff < 0) {
 			other->h += ABS(tdiff);
 			other->t = t;
 		} else {
 			l -= ABS(tdiff);
 			t = other->t;
 		}
 		tdiff = 0;
 	}
 	h = MAX(h, other->h) + diff / 2;
 	l = MIN(l, other->l) - diff / 2;
 	t = (t + other->t) / 2 + diff / 2;
 	l -= tdiff / 2;
 	h -= tdiff / 2;
 
 }
 
 list<Group*> groups;
 
 int main() {
 
 	int T;
 	scanf("%d", &T);
 
 	for (int t = 1; t <= T; t++) {
 		groups.clear();
 
 		int C, D;
 		scanf("%d%d", &C, &D);	// Points, distance
 
 		int p, v;
 		for (int i = 0; i < C; i++) {
 			scanf("%d%d", &p, &v);
 			groups.push_back(new Group((double)D / 2, p, v));
 		}
 
 		while(true) {
 			Group *last = NULL;
 			list<Group*> toRemove;
 			for (list<Group*>::iterator iter = groups.begin(); iter != groups.end(); iter++) {
 				if (last != NULL) {
 					if ((*iter)->l < last->h) {
 						last->merge(*iter);
 						toRemove.push_back(*iter);
 						continue;
 					}
 				}
 				last = *iter;
 			}
 
 			if (toRemove.size() == 0) {
 				break;
 			}
 
 			for (list<Group*>::iterator iter = toRemove.begin(); iter != toRemove.end(); iter++) {
 				groups.remove(*iter);
 			}
 		}
 
 		double maxTime = 0;
 		for (list<Group*>::iterator iter = groups.begin(); iter != groups.end(); iter++) {
 			if ((*iter)->t > maxTime) {
 				maxTime = (*iter)->t;
 			}
 		}
 
 		printf("Case #%d: %lf\n", t, maxTime);
 	}
 	return 0;
 }
