#include <algorithm>
 #include <cassert>
 #include <cstdint>
 #include <fstream>
 #include <iostream>
 #include <vector>
 
 using namespace std;
 
 string makeOutName(string inName)
 {
   auto outName = inName;
   auto length = inName.size();
   outName[length - 2] = 'o';
   outName[length - 1] = 'u';
   outName += 't';
   return outName;
 }
 
 uint32_t c, d;
 vector<int64_t> state;
 
 int64_t dist(int64_t x, int64_t y)
 {
   return abs(x - y);
 }
 
 void spread()
 {
    for (auto i=0; i<state.size(); ++i)
    {
      if ( ( i < (state.size()-1)      ) &&
           ( d > (state[i+1]-state[i]) ) )
      {
        state[i] -= 5; }
      else if ( ( i > 0 ) &&
                ( d > (state[i] - state[i-1]) ) )
      {
        state[i] += 5;
      }
    }
 }
 
 bool is_spread()
 {
    for (auto i=0; i<state.size() - 1; ++i)
    {
       if (state[i+1] - state[i] < d)
       { return false; }
    }
    return true;
 }
 
 uint32_t simulate()
 {
   uint32_t timeElapsed(0);
 
   while (!is_spread())
   {
     spread();
     timeElapsed += 5;
   }
 
   return timeElapsed;
 }
 
 int main(int argc, char* argv[])
 {
   // Open input file
   fstream inFile(argv[1], fstream::in);
   if (!inFile.is_open())
   {
     cout << "Failed to open " << argv[1] << endl;
     return -1;
   }
 
   // Open output file
   auto outName = makeOutName(argv[1]);
   fstream outFile(outName, fstream::out);
   if (!outFile.is_open())
   {
     cout << "Failed to open " << outName << endl;
     return -1;
   }
 
   uint32_t numCases(0);
   inFile >> numCases;
 
   for (auto i = 0; i < numCases; ++i)
   {
     outFile << "Case #" << i+1 << ": ";
 
     inFile >> c >> d;
     d *= 10;
 
     // Read in data
     state.clear();
     for (auto i = 0; i < c; ++i)
     {
       uint32_t vendors;
       int32_t point;
       inFile >> point >> vendors;
       for (int j = 0; j < vendors; ++j) { state.push_back(point * 10); }
     }
     sort(state.begin(), state.end());
     auto timeElapsed = simulate();
     outFile << static_cast<float>(timeElapsed) / 10.0F << endl;
   }
 
   inFile.close();
   outFile.close();
   return 0;
 }
 
