#include <iostream>
 #include <vector>
 
 using namespace std;
 
 int C;
 long D;
 double t;
 
 struct Group {
     double start;
     double end;
     double length;
     double mint;
     double left()
     {
         return length-(end-start);
     }
     void dostep(double tstep)
     {
         start -= tstep;
         end += tstep;
         mint -= tstep;
         if(mint < 0) mint = 0;
     }
 };
 
 vector<Group> groups;
 
 void dostep(double tstep)
 {
     t += tstep;
     for(int i = 0; i < groups.size(); i++) {
         groups[i].dostep(tstep);
     }
 }
 
 bool step()
 {
     double mint = -1;
     int mini = -1;
     bool remove = false;
     for(int i=0; i < groups.size(); i++) {
         Group g = groups[i];
         double t1 = (g.left() - 2*D)/2.0;
         if(t1 < g.mint) t1 = g.mint;
         if(t1 < mint || mint < 0) {
             mint = t1;
             mini = i;
             remove = true;
         }
         if(i+1 == groups.size()) continue;
         Group g2 = groups[i+1];
         double t2 = (g2.start - g.end)/2.0;
         if(t2 < mint) {
             mint = t2;
             mini = i;
             remove = false;
         }
     }
     if(mint < 0) return false;
     dostep(mint);
     if(remove) {
         groups.erase(groups.begin()+mini);
     } else {
         groups[mini].end = groups[mini+1].end;
         groups[mini].length += groups[mini+1].length - D; 
         groups.erase(groups.begin()+mini+1);
     }
     return true;
 }
 
 void solve()
 {
     t = 0.0;
     // Merge
     int i = 0;
     while(i+1 < groups.size()) {
         Group g1 = groups[i];
         Group g2 = groups[i+1];
         double end = g1.end + g1.left()/2.0;
         double start = g2.start - g2.left()/2.0;
         if(end >= start) {
             groups[i].length += g2.length - D;
             groups[i].end = g2.end;
             groups[i].mint += g2.mint;
             groups.erase(groups.begin()+i+1);
         } else {
             i++;
         }
     }
     while(step()) {}
 }
 
 int main()
 {
     int T;
     cin >> T;
     for(int tc=0; tc < T; tc++) {
         cin >> C;
         cin >> D;
         long V;
         long P;
         for(int i=0; i < C; i++) {
             cin >> P >> V;
             Group g;
             g.start = P;
             g.end = P;
             g.length = (1+V)*D;
             g.mint = (V-1)*D/2.0;
             groups.push_back(g);
         }
         solve();
         cout << "Case #" << tc+1 << ": " << t << endl;
     }
 }
