#include <iostream>
 #include <fstream>
 #include <cstdio>
 #include <string>
 #include <algorithm>
 #include <string.h>
 #include <vector>
 #include <map>
 #include <set>
 #include <cmath>
 #include <iomanip>
 using namespace std;
 
 double const eps = 1e-8;
 int n, d;
 int p[220], v[220];
 
 inline double f(double x){
 	double cur = x;
 	double maxrez = -1.0;
 	for(int i=0; i<n; i++){
 		double maxp = -1;
 		for(int z=0; z<v[i]; z++){
 			double r = fabs(cur-p[i]);
 			maxp = max(maxp,r);
 			cur+=d;
 		}
 		maxrez = max(maxrez,maxp);
 	}
 	return maxrez;
 }
 
 int main(){
 	ifstream cin("input.txt");
 	ofstream cout("output.txt");
 	int ntests;
 	cin>>ntests;
 	for(int testnum=0; testnum<ntests; testnum++){
 		cin>>n>>d;
 		for(int i=0; i<n; i++) cin>>p[i]>>v[i];
 		double x1, x2;
 		double lx = -10000000000000.0, rx = 10000000000000.0;
 		double lv = f(lx);
 		double rv = f(rx);
 		double xv1, xv2;
 		while(rx-lx>=eps){
 			x1 = lx+(rx-lx)/3.0;
 			x2 = lx+(rx-lx)/3.0*2.0;
 			xv1 = f(x1);
 			xv2 = f(x2);
 			if(xv1<=xv2 && xv2<=rv){
 				rx = x2;
 				rv = xv2;
 			}else{
 				lx = x1;
 				lv = xv1;
 			}
 		}
 		cout<<"Case #"<<testnum+1<<": "<<setiosflags(ios::showpoint|ios::fixed)<<setprecision(6)<<f(rx)<<endl;
 	}
 	return 0;
 }
