#include<stdio.h>
 #include<string>
 #include<math.h>
 #include<algorithm>
 #include<vector>
 #include<stdlib.h>
 
 using namespace std;
 
 struct SSite
 {
     int left, right;
     double leftB, rightB;
     int p;
 };
 
 vector<SSite> sites[2];
 int d, c;
 
 double calLeft(SSite &site)
 {
     return (site.left + site.right - (site.p - 1)*d) / 2.0;
 }
 
 double calRight(SSite &site)
 {
     return (site.left + site.right + (site.p - 1)*d) / 2.0;
 }
 
 double solve()
 {
     int i, j, k;
     bool changed;
     int flag;
     double leftB, rightB, nextLeftB, nextRightB;
 
     flag = 0;
     sites[1-flag].clear();
     while (sites[0].size() != sites[1].size()) {
         sites[1-flag].clear();
         i = 0;
         while (i < sites[flag].size()) {
             SSite newSite;
             newSite.left = sites[flag][i].left;
             newSite.right = sites[flag][i].right;
             newSite.p = sites[flag][i].p;
             newSite.leftB = calLeft(newSite);
             newSite.rightB = calRight(newSite);
             for (j = i+1; j < sites[flag].size(); j ++) {
                 if (sites[flag][j].leftB - d >= newSite.rightB) {
                     break;
                 }
                 else {
                     newSite.left = min(newSite.left, sites[flag][j].left);
                     newSite.right = max(newSite.right, sites[flag][j].right);
                     newSite.p += sites[flag][j].p;
                     newSite.leftB = calLeft(newSite);
                     newSite.rightB = calRight(newSite);
                 }
             }
             newSite.leftB = calLeft(newSite);
             newSite.rightB = calRight(newSite);
             sites[1-flag].push_back(newSite);
             i = j;
         }
 
         flag = 1-flag;
     }
 
     double maxTime = 0;
     for (i = 0; i < sites[flag].size(); i ++) {
         if (sites[flag][i].left - sites[flag][i].leftB > maxTime)
             maxTime = sites[flag][i].left - sites[flag][i].leftB;
     }
 
     return maxTime;
 }
 
 
 int main()
 {
     int i, j, k;
     int t, nowt;
     int flag;
 
     freopen("B-small-attempt1.in", "r", stdin);
     freopen("B-small-attempt1.out", "w", stdout);
     
 
     scanf("%d", &t);
     nowt = 0;
     while (t --) {
         nowt ++;
         flag = 0;
         scanf("%d%d", &c, &d);
         sites[0].clear();
         for (i = 0; i < c; i ++) {
             SSite site;
             scanf("%d%d", &site.left, &site.p);
             site.right = site.left;
             site.leftB = calLeft(site);
             site.rightB = calRight(site);
             sites[0].push_back(site);
         }
 
         printf("Case #%d: %.20lf\n", nowt, solve());
     }
 
     return 0;
 }