#include <string>
 #include <iostream>
 #include <fstream>
 #include <sstream>
 #include <vector>
 #include <set>
 #include <algorithm>
 #include <cstdlib>
 #include <cfloat>
 #include <cmath>
 
 using namespace std;
 
 typedef vector<long>::iterator longIt;
 typedef vector<double>::iterator doubleIt;
 typedef vector<string>::iterator stringIt;
 typedef vector<vector<long> >::iterator vecIntIt;
 typedef vector<vector<double> >::iterator vecDoubleIt;
 typedef vector<vector<string> >::iterator vecStringIt;
 
 template <class T>
 inline const T max_arg(const T& a, const T& b) {
 	return (b<a)?1:2;
 }
 
 template <class T>
 inline bool from_string(T& t, const string& s,
 				 std::ios_base& (*f)(std::ios_base&)) {
 	istringstream iss(s);
 	return !(iss>>f>>t).fail();
 }
 
 template <class T>
 inline string to_string(const T& t) {
 	stringstream ss;
 	ss<<t;
 	return ss.str();
 }
 
 int main(int argc, char **argv) {
 	ifstream inp(argv[1]); //input file
 	ofstream outp((string(argv[1])+".out").c_str()); //output file
 
 	int t;
 	inp>>t;
 
 	for(int i=0; i<t; i++) {
 
 	/* Code goes here */
 
 		long c;
 		long d;
 		inp>>c>>d;
 		long p[c];
 		long v[c];
 		long totalv=0;
 		double mean=0;
 		for (long j=0; j<c; j++) {
 			inp>>p[j]>>v[j];
 			totalv+=v[j];
 			mean+=p[j];
 		}
 		mean/=c;
 		double max_time=0;
 		for (int j=0; j<c; j++) {
 			double time=0;
 			double time_disp=double(d*(v[j]-1))/2.0;
 			long vleft=0;
 			long vright=0;
 			long cleft=0;
 			long cright=0;
 			double meanleft=0;
 			double meanright=0;
 			long minleft = p[j];
 			long minright = p[j];
 			double distl=DBL_MAX;
 			double distr=DBL_MAX;
 			for (long k=0; k<c; k++) {
 				if (p[k] < p[j]) {
 					if ((p[j]-p[k]) < distl) {
 						distl = p[j] - p[k];
 						minleft=p[k];
 					}
 					vleft+=v[k];
 					cleft++;
 					meanleft+=p[k];
 				}
 				if (p[k] > p[j]) {
 					if ((p[k]-p[j]) < distr) {
 						distr = p[k] - p[j];
 						minright=p[k];
 					}
 					vright+=v[k];
 					cright++;
 					meanright+=p[k];
 				}
 			}
 			meanleft/=cleft;
 			meanright/=cright;
 			double time_off=0;
 			if (meanleft + double(d*(vleft-1))/2.0 > p[j] - double(d*(v[j]-1))/2.0) {
 				time_off = ((meanleft + double(d*(vleft-1))/2.0) - (p[j] - double(d*(v[j]-1))/2.0))/2;
 			}
 			if (meanright - double(d*(vright-1))/2.0 < p[j] + double(d*(v[j]-1))/2.0) {
 				time_off -= ((p[j] + double(d*(v[j]-1))/2.0) - (meanright - double(d*(vright-1))/2.0))/2;
 			}
 			max_time = max(max_time, time_disp+abs(time_off));
 		}
 		outp<<"Case #"<<i+1<<": "<<max_time;
 		if (i!=t-1) outp<<endl;
 
 	/* End of code */
 
 	}
 
 	inp.close();
 	outp.close();
 }
