#include <cstdio>
 #include <iostream>
 #include <vector>
 #include <string>
 #include <algorithm>
 #include <map>
 #include <cmath>
 
 int main(){
 
     std::freopen("small.in", "r", stdin);
     std::freopen("small.out", "w", stdout);
 
     int t;
     std::scanf("%d", &t);
 
     double speed = 1.0;
 
     for(int i = 0; i < t; i++){
 
         int C, D;
         std::scanf("%d %d", &C, &D);
 
         std::map<int,int> pvs;
         std::vector<int> ps;
         double centroid = 0;
         int numVendors = 0;
         int minP = 0;
         int maxP = 0;
         for(int j = 0; j < C; j++){
 
             int P, V;
             std::scanf("%d %d", &P, &V);
             pvs[P]=V;
             ps.push_back(P);
             centroid += static_cast<double>(P)*static_cast<double>(V);
             numVendors += V;
             if(j == 0){
                 minP = P;
                 maxP = P;
             }
             else{
                 if(P > maxP){
                     maxP = P;
                 }
                 if(P < minP){
                     minP = P;
                 }
             }
 
         }
 
         centroid /= static_cast<double>(C);
 
         double endPointMax = 0;
         double endPointMin = 0;
         if(numVendors % 2 == 0){
             double d = static_cast<double>(D)/2.0 + (static_cast<double>(numVendors)/2.0-1.0)*static_cast<double>(D);
             endPointMax = centroid + d;
             endPointMin = centroid - d;
         }
         else{
             double d = (static_cast<double>(numVendors-1)/2.0)*static_cast<double>(D);
             endPointMax = centroid + d;
             endPointMin = centroid - d;
         }
 
         double maxDist = 0;
         double currentSpot = endPointMin;
 
         for(int j = 0; j < ps.size(); j++){
             int p = ps[j];
             double dist = std::abs(currentSpot-static_cast<double>(p));
             currentSpot += pvs[p]*D;
             if(j == 0 || dist > maxDist){
                 maxDist = dist;
             }
         }
 
 
         double time = maxDist*speed;
 
         std::printf("Case #%d: %.9f\n", i+1,time);
 
     }
 
     return 0;
 
 }
 
