/* 
 Google Codejam 
 2011 Round 1B
 
 B. Revenge of the Hot Dogs
 
 C++ Solution by:
  Marco Chiesi
  chiesi@gmail.com
 */
 
 #include <string>
 #include <sstream>
 #include <fstream>
 #include <iostream>
 #include <cmath>
 #include <iomanip>
 
 using namespace std;
 
 /**
  * Class for a single instance of the problem
  */
 class Instance {
     private:
         double solution;
         double D;
         int C;
         double *P;
         int *V;
 
     public:
 	void readInput(istream &in) {
         in >> C;
         in >> D;
         P = new double[C];
         V = new int[C];
 		for (int i = 0; i < C ; i++) {
             in >> P[i];
             in >> V[i];
         }
 	}
 
 	void solve() {
         double sum = 0;
         double num = 0;
 		for (int i = 0; i < C ; i++) {
             sum += V[i]*P[i];
             num += V[i];
         }        //double center = sum / num;
         double center = (P[0]+P[C-1])/2;
         double nextpos = center - (num-1)/2*D;
         solution = 0;
 		for (int i = 0; i < C ; i++) {
             for (int j = 0; j < V[i]; j++) {
                 double dist = (double) abs ((double)(P[i] - nextpos));
                 if (dist > solution) {
                    solution = dist;
                 }
                 nextpos += D;
             }
         }        
 	}
 
 	string getSolution() {
     	stringstream ss;
         ss << setiosflags(ios::fixed) << setprecision(6) << solution;
 		return ss.str();
 	}
 };
 
 /**
  * Class for a problem
  */
 class Problem {
 	private:
         Instance *instances;
 	    int cases;
 	
 	public:
 	void readInput(istream &in) {
 		in >> cases;
 		instances = new Instance[cases];
 		for (int i = 0; i < cases; i++) {
 			instances[i].readInput(in);
 		}
 	}
 	
 	void solve() {
 		for (int i = 0; i < cases; i++) {
 			instances[i].solve();
 		}
 	}
 	
 	void writeOutput(ostream &out) {
 		for (int i = 0; i < cases; i++) {
 			out << "Case #" << i+1 << ": " << instances[i].getSolution() << endl;
 		}
 	}
 };
 
 /**
  * Main function
  */
 int main(int argc, char *argv[]) {
     istream *in;
     ostream *out;
     if (argc > 1) {
         in = new fstream(argv[1], fstream::in);
     }
     else {
         in = &cin;
     }
     if (argc > 2) {
         out = new fstream(argv[2], fstream::out);
     }
     else {
         out = &cout;
     }
     Problem *problem = new Problem();
     problem->readInput(*in);
     problem->solve();
     problem->writeOutput(*out);
     return 0;
 }
