#include<stdio.h>
 
 #define BOOL int
 #define FALSE 0
 #define TRUE 1
 
 #define MAX_USED_POINTS 200
 
 #define WORST_CASE_TIME 200000000 // 10^6 * 200
 
 #define MAX_VENDORS 100000
 
 #define abs(x) ((x)>0)?(x):(-(x))
 
 
 
 int
 main(void)
 {
   int T, iT;
   int C, D;
   int iC;
   int P[MAX_USED_POINTS];
   int V[MAX_USED_POINTS];
   double min_delta;
   long total_vendors; // also is denominator universal to all fractions
   long start_pos_numerator;
   int pos[MAX_VENDORS]; // pos[3] is where vendor 3 is located
   long iVendor;
   double max_delta;
   double delta;
 
   scanf("%d", &T);
   for(iT = 1; iT <= T; ++iT) {
     scanf("%d %d", &C, &D);
 
     total_vendors = 0L;
     for(iC = 1; iC <= C; ++iC) {
       scanf("%d %d", &(P[iC]), &(V[iC]));
       for(iVendor = 0; iVendor < V[iC]; ++iVendor) {
         pos[iVendor+total_vendors] = P[iC]; // here total_vendors is only total vendors seen so far
       }
       
       total_vendors += V[iC];
     }
 
     min_delta = WORST_CASE_TIME;
 
     // start position = start_pos_numerator / total_vendors ... starts at P[0] - (D*total_vendors) ... goes to P[C-1] + (D*total_vendors)
 
     for(start_pos_numerator = (P[0] - (D*total_vendors))*total_vendors; start_pos_numerator <= P[C-1] + (D*total_vendors); ++start_pos_numerator) {
       max_delta = 0.0;
       for(iVendor = 0; iVendor < total_vendors; ++iVendor) {
         // compare pos[] w/ (start position, start position + D, start position + 2D, ...)
         delta = abs( ( ((double)(start_pos_numerator))/total_vendors + D*iVendor) - pos[iVendor] );
         if(delta > max_delta) {
           max_delta = delta;
         }
       }
 
       if(max_delta < min_delta) {
         min_delta = max_delta;
       }
     }
 
     printf("Case #%d: %lf\n", iT, min_delta);
   }
 
   return(0);
 }
