#include <iostream>
 #include <sstream>
 #include <fstream>
 #include <algorithm>
 #include <vector>
 #include <list>
 #include <string>
 #include <map>
 #include <set>
 #include <queue>
 #include <stack>
 #include <complex>
 #include <cstdio>
 #include <cassert>
 #include <cmath>
 
 #if defined (__GNUC__) && (__GNUC__ <= 2)
 #include <hash_map>
 #include <hash_set>
 #else
 #include <ext/hash_map>
 #include <ext/hash_set>
 using namespace __gnu_cxx;
 #endif
 namespace __gnu_cxx {
 template<> struct hash<std::string>  {
 	size_t operator()(const std::string& s) const {
 		return __stl_hash_string(s.c_str());
 	}
 };
 }
 using namespace std;
 
 // for loops
 #define FOR(i, b, e) for (int i = (b), _e = e; i < _e; i ++)
 #define REP(i, n) FOR(i, 0, (n))
 #define FOR_REV(i, rb, b) for (int i = (rb), _b = (b); i >= _b; i --)
 
 // for each
 #define sz size()
 template<class T> inline int size(const T &c) { return c.sz; }
 #define FOR_EACH(i, c) REP(i, size(c))
 
 // iterating stl containers
 #define itype(c) __typeof((c).begin())
 #define ITER(it, c) for(itype(c) it = (c).begin(); it != (c).end(); it ++)
 
 // sort and reverse containers
 #define pb push_back
 #define pf push_front
 #define all(c) (c).begin(), (c).end()
 #define SORT(c) sort(all(c))
 #define REVERSE(c) reverse(all(c))
 
 // vectors and string streams
 typedef long long LL;
 typedef vector<int> VI;
 typedef vector<VI> VVI;
 typedef vector<string> VS;
 LL s2i(string s) { istringstream i(s); LL x; i >> x; return x; }
 template <class T> string i2s(T x) { ostringstream o; o << x; return o.str(); }
 
 // special values
 #define PI acos(-1.)
 #define EPS 1e-308
 #define INT_INF static_cast<int>((1LL << (sizeof(int) * 8 - 1)) - 1)
 
 LL D;
 
 struct Interval {
 	LL left, right, n;
 	LL mid() { return (left + right) / 2; }
 	LL min() {
 		return mid() - (n - 1) * D / 2;
 	}
 	LL max() {
 		return mid() + (n - 1) * D / 2;
 	}
 	bool far(Interval &i) {
 		return this->min() - i.max() >= D;
 	}
 	void update(Interval &i) {
 		this->left = i.left;
 		this->n += i.n;
 	}
 	LL get() {
 		return max() - right;
 	}
 };
 
 int main() {
 	int T, case_num = 0;
 	cin >> T;
 	while (T != case_num ++) {
 		LL ans = 0;
 		LL C, P, V;
 		stack<Interval> S;
 		cin >> C >> D;
 		D *= 2;
 		REP(i, C) {
 			cin >> P >> V;
 			P *= 2;
 			Interval itv = { P, P, V };
 			while (!S.empty()) {
 				Interval top_itv = S.top();
 				if (!itv.far(top_itv)) {
 					S.pop();
 					itv.update(top_itv);
 				} else { break; }
 			}
 //			cout << itv.left << ", " << itv.right << ", " << itv.n << endl;
 			S.push(itv);
 		}
 		while (!S.empty()) {
 			Interval top_itv = S.top(); S.pop();
 			LL curr = top_itv.get();
 			if (ans < curr) { ans = curr; }
 		}
 		cout << "Case #" << case_num << ": " << ans / 2.0 << "\n";
 	}
 	return 0;
 }
