#include <iostream>
 #include <vector>
 #include <algorithm>
 #include <cmath>
 
 using namespace std;
 
 typedef vector< pair< int, int > > Vendors;
 
 double calc_time(double D, double anchor, Vendors const &vendors)
 {
   double t = 0;
   int d = 0;
   for ( unsigned i = 0; i < vendors.size(); ++i )
   {
     for ( int j = 1; j <= vendors[i].second; ++j )
     {
       double dist = fabs(anchor + d*D - vendors[i].first);
       ++d;
       t = max(t, dist);
     }
   }
   return t;
 }
 
 
 double find_min(double D, Vendors const &vendors, double eps)
 {
   int nvend = 0;
   for ( unsigned i = 0; i < vendors.size(); ++i )
     nvend += vendors[i].second;
   double left = vendors[0].first - nvend*D;
   double right = vendors.back().first + D;
   while ( right - left > eps )
   {
     double lT = (left*2 + right)/3;
     double rT = (left + right*2)/3;
     double fl = calc_time(D, lT, vendors);
     double fr = calc_time(D, rT, vendors);
     if ( fl >= fr )
       left = lT;
     else
       right = rT;
   }
   return calc_time(D, (right + left)/2, vendors);
 }
 
 
 void read_data(Vendors &vendors, double &D)
 {
   vendors.clear();
   unsigned C;
   cin >> C >> D;
   for ( unsigned i = 0; i < C; ++i )
   {
     int P, V;
     cin >> P >> V;
     vendors.push_back(make_pair(P, V));
   }
   sort(vendors.begin(), vendors.end());
 }
 
 
 int main()
 {
   int T;
   cin >> T;
   cout.precision(15);
   for ( int t = 1; t <= T; ++t )
   {
     Vendors v;
     double D;
     read_data(v, D);
     double tm = find_min(D, v, 1e-9);
     cout << "Case #" << t << ": " << tm << '\n';
   }
   return 0;
 }
