/*
  * main.cpp
  *
  *  Created on: May 21, 2011
  *      Author: stefan
  */
 
 #include <iostream>
 #include <fstream>
 #include <cmath>
 using namespace std;
 
 struct position{
 	int P;
 	int V;
 
 	position* next;
 	position* previous;
 
 	position() : P(0), V(0), next(0), previous(0) { }
 	position(int p, int v) : P(p), V(v), next(0), previous(0) { }
 };
 
 int main(){
 	ifstream in("input.txt");
 	ofstream out("output.txt");
 
 	int T;
 	in>>T;
 
 	for(int caseNr = 1; caseNr <= T; caseNr++){
 		int C, D;
 		in>>C>>D;
 
 
 		position *first, *last, *current;
 		first = 0;
 		last = 0;
 		current = 0;
 
 		for(int i = 0; i < C; i++){
 			int P, V;
 			in>>P>>V;
 
 			position* temp = new position(P, V);
 			if(first == 0){
 				first = temp;
 				last = temp;
 			}
 
 			if(current != 0){
 				temp->previous = current;
 				current->next = temp;
 			}
 
 			current = temp;
 		}
 
 		last = current;
 
 		// process data
 		double time = 0.0;
 		int moved_stands = 0;
 
 		current = first;
 		while(current != 0){
 			int available_space = 0;
 			if(current->previous != 0){
 				int temp = (current->P - current->previous->P);
 				available_space = abs((double)temp);
 			}
 
 			if(current->next != 0){
 				int temp = (current->P - current->next->P);
 				if(abs((double)temp) < available_space)
 					available_space = abs((double)temp);
 			}
 
 
 			int previousTime = 0;
 			if(current->V > 0){
 				if(available_space >= D){
 					previousTime = 0;
 					available_space = 0;
 				}
 				else{
 					previousTime = D - available_space;
 					moved_stands++;
 				}
 			}
 
 			for(int i = 1; i < current->V; i++){
 				int currentTime = previousTime + D;
 				time+= currentTime;
 				previousTime = currentTime;
 
 				moved_stands++;
 			}
 
 			current = current->next;
 		}
 
 		if(moved_stands > 0)
 			time = time / moved_stands;
 
 		out.precision(12);
 		cout.precision(12);
 
 		// write results
 		out<<"Case #"<<caseNr<<": "<<time<<endl;
 		cout<<"Case #"<<caseNr<<": "<<time<<endl;
 	}
 
 	out.close();
 	in.close();
 	return 0;
 }
