#include<cstdio>
 #include<cmath>
 #include<vector>
 #include<algorithm>
 
 using namespace std;
 
 const int MAXN = 1100000;
 const double ERRO = 1e-7;
 
 struct state {
 	double res;
 	double last;
 };
 
 state dp[MAXN];
 
 double timeToDist (double p1, double p2, int d) {
 	if(abs(p1 - p2) > (double)d)
 		return 0.0;
 	else
 		return ((d - abs(p1-p2)) / 2.0);
 }
 
 double minTime(vector<int> vendors, int d) {
 //	for(int i = 0; i < vendors.size(); i++)
 //		printf("vendors[%d] = %d\n", i, vendors[i]);
 
 	if(vendors.size() <= 1) return 0.0;
 
 	int vs = vendors.size();
 	// dp
 	dp[0].res = 0.0;
 	dp[0].last = (double)vendors[0];
 
 	dp[1].res = timeToDist(dp[0].last, (double)vendors[1], d);
 	dp[1].last = (double)vendors[1] + dp[1].res;
 
 //	printf("dp[1].res = %lf e last = %lf\n", dp[1].res, dp[1].last);
 
 	for(int i = 2; i < vs; i++) {
 		double curr = (double)vendors[i];
 		double myres = 0.0;
 		if(curr < dp[i-1].last) {
 			myres = abs(curr - dp[i-1].last);
 			curr = dp[i-1].last;
 
 			double aux = timeToDist(curr, dp[i-1].last, d);
 			curr += aux;
 			dp[i].res = max(dp[i-1].res, myres) + aux;
 			dp[i].last = curr;
 		}
 		else {
 			double aux = timeToDist(curr, dp[i-1].last, d);
 			if(abs(aux) < ERRO)
 				curr -= min((curr - dp[i-1].last) - d, dp[i-1].res);
 			dp[i].res = dp[i-1].res + aux;
 			dp[i].last = curr + aux;
 		}
 
 //		printf("dp[%d].res = %lf e last = %lf\n", i, dp[i].res, dp[i].last);
 	}
 
 	return dp[vs-1].res;
 }
 
 int main() {
 	int T = 0;
 	scanf("%d", &T);
 
 	for(int caseNum = 1; caseNum <= T; caseNum++) {
 		int c = 0, d = 0;
 		scanf("%d %d", &c, &d);
 
 		vector<int> vendors;
 
 		for(int i = 0; i < c; i++) {
 			int p = 0, v = 0;
 			scanf("%d %d", &p, &v);
 
 			for(int j = 0; j < v; j++)
 				vendors.push_back(p);
 		}
 
 		printf("Case #%d: %.10lf\n", caseNum, minTime(vendors, d));
 	}
 
 	return 0;
 }
