///////////////////////////////////////////////////////////////////////
 /////    The code is written for Google Code Jam 2011 contest.    /////
 /////    You may use any part of this code without exception.     /////
 /////    The author is not responsible for any consequences       /////
 /////    of using this code.                                      /////
 /////                                                             /////
 /////    Author: Andrey Rubtsov                                   /////
 ///////////////////////////////////////////////////////////////////////
 
 #define _CRT_SECURE_NO_WARNINGS
 #include <algorithm>
 #include <bitset>
 #include <complex>
 #include <deque>
 #include <exception>
 #include <fstream>
 #include <functional>
 #include <hash_map>
 #include <hash_set>
 #include <iomanip>
 #include <ios>
 #include <iosfwd>
 #include <iostream>
 #include <istream>
 #include <iterator>
 #include <limits>
 #include <list>
 #include <locale>
 #include <map>
 #include <memory>
 #include <new>
 #include <numeric>
 #include <ostream>
 #include <queue>
 #include <set>
 #include <sstream>
 #include <stack>
 #include <stdexcept>
 #include <streambuf>
 #include <string>
 #include <strstream>
 #include <utility>
 #include <valarray>
 #include <vector>
 #include <cctype>
 #include <cmath>
 #include <cstdarg>
 #include <cstdio>
 #include <cstdlib>
 #include <ctime>
 
 using namespace std;
 
 #define PROBLEM_NAME "B"
 #define LARGE_INPUT 0
 
 #if LARGE_INPUT
     #define INPUT_FILE PROBLEM_NAME "-large.in"
     #define OUTPUT_FILE PROBLEM_NAME "-large.out"
 #else
     #define INPUT_FILE PROBLEM_NAME "-small-attempt.in"
     #define OUTPUT_FILE PROBLEM_NAME "-small.out"
 #endif
 
 int main()
 {
     freopen(INPUT_FILE,"r",stdin);
     freopen(OUTPUT_FILE,"w",stdout);
 
     int T;
     cin >> T;
 
     for (int i = 0; i < T; ++i)
     {
         int C, D;
         cin >> C >> D;
 
         vector<double> Pos(C);
         vector<double> InitPos(C);
         vector<int> Count(C);
         vector<int> self_dist(C);
 
         for (int j = 0; j < C; ++j)
         {
             cin >> Pos[j] >> Count[j];
             InitPos[j] = Pos[j];
             self_dist[j] = (Count[j] - 1) * D;
         }
 
         for (int j = 1; j < C; ++j)
         {
             double init_dist = Pos[j] - Pos[j-1];
             double req_dist = (self_dist[j-1] + self_dist[j]) / 2.;
 
             if (req_dist <= init_dist)
                 continue;
 
             double off = (req_dist - init_dist) / 2.;
             Pos[j-1] -= off;
             Pos[j] += off;
 
             for (int k = j - 1; k > 0; --k)
             {
                 double init_dist = Pos[k] - Pos[k-1];
                 double req_dist = (self_dist[k-1] + self_dist[k]) / 2.;
 
                 if (req_dist > init_dist)
                 {
                     Pos[k-1] -= off;
                 }
             }
 
             for (int k = j + 1; k < C; ++k)
             {
                 double init_dist = Pos[k] - Pos[k-1];
                 double req_dist = (self_dist[k-1] + self_dist[k]) / 2.;
 
                 if (req_dist > init_dist)
                 {
                     Pos[k] += off;
                 }
             }
 
         }
 
         double max_time = 0.;
 
         for (int j = 0; j < C; ++j)
         {
             max_time = max(max_time, fabs(Pos[j] - InitPos[j]) + self_dist[j] / 2.);
         }
 
         printf("Case #%d: %f\n", i+1, max_time);
     }
 
     return 0;
 }