#include <algorithm>
 #include <iostream>
 #include <sstream>
 #include <string>
 #include <vector>
 #include <queue>
 #include <set>
 #include <map>
 #include <cstdio>
 #include <cstdlib>
 #include <cctype>
 #include <cmath>
 #include <fstream>
 
 using namespace std;
 
 void calculateWP(const vector<string> & table, vector<double> * wp) {
 	for(int i = 0; i < wp->size(); ++i) {
 		int wins = 0;
 		int loses = 0;
 		for (int j = 0; j < table[i].size(); ++j) {
 			if (table[i][j] == '1') {
 				++wins;
 			}
 			if (table[i][j] == '0') {
 				++loses;
 			}
 		}
 		wp->at(i) = wins * 1.0 / (wins + loses);
 	}
 }
 
 void calculateOWP(const vector<string> & table, vector<double> * owp) {
 	for(int i = 0; i < owp->size(); ++i) {
 		double res = 0;
 		int count = 0;
 		for(int k = 0; k < owp->size(); ++k) {
 			if (table[i][k] != '.') {
 				int wins = 0;
 				int loses = 0;
 				for (int j = 0; j < owp->size(); ++j) {
 					if (i == j) {
 						continue;
 					}
 					if (table[k][j] == '1') {
 						++wins;
 					}
 					if (table[k][j] == '0') {
 						++loses;
 					}
 				}
 				++count;
 				res += wins * 1.0 / (wins + loses);
 			}
 		}
 		owp->at(i) = res / count;
 	}
 }
 
 void calculateOOWP(const vector<string> & table, const vector<double> owp, vector<double> * oowp) {
 	for(int i = 0; i < oowp->size(); ++i) {
 		double res = 0;
 		int count = 0;
 		for(int k = 0; k < oowp->size(); ++k) {
 			if (table[i][k] != '.') {
 				res += owp[k];
 				++count;
 			}
 			oowp->at(i) = res / count;
 		}
 	}
 }
 
 
 string solveA(ifstream & input) {
 	int teamsCount;
 	input >> teamsCount;
 	vector<string> table(teamsCount);
 	for (int i = 0; i < teamsCount; ++i) {
 		input >> table[i];
 	}
 	vector<double> wp(teamsCount);
 	vector<double> owp(teamsCount);
 	vector<double> oowp(teamsCount);
 
 	calculateWP(table, &wp);
 	calculateOWP(table, &owp);
 	calculateOOWP(table, owp, &oowp);
 	ostringstream res("");
 	for(int i = 0; i < teamsCount; ++i) {
 		res << '\n';
 		//cout << "wp = " << wp[i] << " owp = " << owp[i] << " oowp = " << oowp[i] << endl;
 		res << (wp[i] * 0.25 + owp[i] * 0.5 + oowp[i] * 0.25);
 	}
 
 	return res.str();
 }
 
 class interval {
 public:
 	double left;
 	double right;
 	double price;
 	interval(double l, double r, double p): left(l), right(r), price(p){}
 	void print() {
 		cout << "interval: left = " << left << " right = " << right << " price = " << price << endl;
 	}
 };
 
 bool intersects(const interval & a, const interval & b, int dist) {
 	if (a.price == -1 || b.price == -1) {
 		return false;
 	}
 	return !(a.right + dist < b.left || b.right + dist < a.left);
 }
 
 interval intUnion (interval & a, interval & b, int dist) {
 	if (a.left + a.right > b.left + b.right) {
 		return intUnion(b, a, dist);
 	}
 	double radA = (a.right - a.left) / 2;
 	double radB = (b.right - b.left) / 2;
 
 	double rad = radA + radB + dist * 0.5;
 	double centerDist = (b.left + b.right) / 2 - (a.left + a.right) / 2;
 	double diff = radA + radB + dist - centerDist;
 	double center, price;
 
 
 	if (b.price - a.price > diff ) {
 		price = b.price;
 		center = (b.left + b.right) / 2 - (a.right - a.left + dist) / 2;
 	} else {
 		if (a.price - b.price > diff ) {
 			price = a.price;
 			center = (a.left + a.right) / 2 +  (b.right - b.left + dist) / 2;
 		} else {
 			price = (a.price + b.price + diff) / 2;
 			center = (a.left + b.right + a.price + b.price) / 2;
 		}
 	}
 	/*cout << "union: " << endl;
 	a.print();
 	b.print();
 	cout << "result: ";*/
 	interval(center - rad, center + rad, price).print();
 	return interval(center - rad, center + rad, price);
 }
 
 double solveB(ifstream & input) {
 	int pointsCount, dist;
 	input >> pointsCount;
 	input >> dist;
 	vector<int> points(pointsCount);
 	vector<int> vendorsCount(pointsCount);
 	vector<interval> intervals;
 	for (int i = 0; i < pointsCount; ++i) {
 		input >> points[i];
 		input >> vendorsCount[i];
 		double rad = 0.5 * (vendorsCount[i] - 1) * dist;
 		intervals.push_back(interval(points[i] - rad, points[i] + rad, rad));
 		//intervals[i].print();
 	}
 	for (int i = 0; i < pointsCount; ++i) {
 		bool finished = false;
 		while (!finished) {
 			finished = true;
 			for (int j = 0; j < pointsCount; ++j) {
 				if (i == j) {
 					continue;
 				}
 				if (intersects(intervals[i], intervals[j], dist)) {
 					intervals[i] = intUnion(intervals[i], intervals[j], dist);
 					intervals[j].price = -1;
 					finished = false;
 				}
 			}
 		}
 	}
 	double max = 0;
 	for (int i = 0; i < pointsCount; ++i) {
 		cout << intervals[i].price << " ";
 		if (intervals[i].price > max) {
 			max = intervals[i].price;
 		}
 	}
 	cout << endl;
 	return max;
 }
 
 
 int main() {
 	ifstream input("input.txt");
 	ofstream output("output.txt");
 	int testCount;
 	input >> testCount;
 	for (int test = 0; test < testCount; ++test) {
 		cout << "Case #" << test + 1 << endl;
 		output << "Case #" << test + 1 << ": " << solveB(input) << endl;
 	}
 	return 0;
 }