#include <stdio.h>
 #include <stdlib.h>
 #include <ctype.h>
 #include <string.h>
 
 struct vine {
 	int d;
 	int l;
 };
 
 #define MIN(a, b) ((a) < (b) ? (a) : (b))
 
 #define MAXN 20000
 
 int n;
 int d;
 struct vine v[MAXN];
 
 /* At position 'pos', holding vine 'vine'
  * we can reach any position up to MIN(2 * vine.d - pos, vine.d + l) */
 int dfs(int pos, int vine)
 {
 	int i;
 	const int reach = MIN(2 * v[vine].d - pos, v[vine].d + v[vine].l);
 
 	/* Can reach the end */
 	if (reach >= d)
 		return 1;
 
 	for (i = vine + 1; i < n && reach >= v[i].d; i++)
 	{
 		/* Can reach vine i at position vine.d */
 		if (dfs(v[vine].d, i))
 			return 1;
 	}
 
 	/* Bomb */
 	return 0;
 }
 
 void do_test(int t)
 {
 	int i;
 
 	scanf("%d", &n);
 
 	for (i = 0; i < n; i++)
 	{
 		scanf("%d %d", &v[i].d, &v[i].l);
 	}
 
 	scanf("%d", &d);
 
 	printf("Case #%d: %s\n", t + 1, dfs(0, 0) ? "YES" : "NO");
 }
 
 int main()
 {
 	int t, i;
 
 	scanf("%d", &t);
 	
 	for (i = 0; i < t; i++)
 		do_test(i);
 
 	return 0;
 }
