#include <vector>
 #include <string>
 #include <algorithm>
 #include <map>
 #include <set>
 #include <queue>
 #include <fstream>
 #include <sstream>
 #include <iostream>
 #include <cstdio>
 #include <cstdlib>
 #include <cmath>
 
 using namespace std;
 
 template<class AnswerType>
 void PrintAnswerToTestCase(size_t caseNumber, AnswerType ans)
 {
 	cerr << "Case #" << caseNumber << endl;
 	cout << "Case #" << caseNumber << ": " << ans << endl;
 }
 
 template <class AnswerType>
 AnswerType SolveTestCase() {
 	int n, D;
 	cin >> n;
 	vector<int> dist(n, 0);
 	vector<int> len(n);
 	for (size_t i = 0; i < n; i++) {
 		cin >> dist[i] >> len[i];
 	}
 	cin >> D;
 	int curPos = 0;
 	int curVine = 0; 
 	while (curVine < n) {
 		int s = dist[curVine] - curPos;
 		if (dist[curVine] + s >= D) 
 			return "YES";
 
 		int nextVine = -1;
 		for (int i = curVine + 1; i < n; i++)	{
 			if (dist[curVine] + s >= dist[i]) {
 				if (nextVine == -1 || dist[i] + min(dist[i] - dist[curVine], len[i]) >  dist[nextVine] + min(dist[nextVine] - dist[curVine], len[nextVine]))
 					nextVine = i;
 			}
 		}
 		if (nextVine == -1)
 			return "NO";
 		curPos = max(dist[curVine], dist[nextVine] - len[nextVine]);
 		curVine = nextVine;
 	}
 
 	return "NO";
 	return 0;
 }
 
 int main()
 {
 	//freopen("input.txt", "r", stdin);
 	freopen("small.in", "r", stdin);
 	//freopen("large.in", "r", stdin);
 
 	freopen("output.txt", "w", stdout);
 
 	int numCases;
 	cin >> numCases;
 
 	for (int caseNumber = 1; caseNumber <= numCases; caseNumber++)
 		PrintAnswerToTestCase(caseNumber, SolveTestCase<string>() );
 
 	return 0;
 }