#pragma comment(linker, "/STACK:1000000000")
 #include <cstdio>
 #include <cmath>
 #include <cstdlib>
 #include <cassert>
 #include <ctime>
 #include <cstring>
 #include <string>
 #include <set>
 #include <map>
 #include <vector>
 #include <iostream>
 #include <algorithm>
 using namespace std;
 #define pb push_back
 #define mp make_pair
 #define fs first
 #define sc second
 
 const double pi = acos(-1.0);
 const int px[] = {0, 1, 1, 0, -1, -1};
 const int py[] = {1, 1, 0, -1, -1, 0};
 const int size = 6 * 1000 + 100;
 
 int s, n;
 bool used[size][size];
 int x[size], y[size];
 bool onfieldmas[size][size];
 bool busy[size][size];
 vector <pair <int, int> > corners;
 set <int> edges;
 
 bool onfield(int x, int y)
 {
 	if (x < 0 || y < 0 || x >= size || y >= size)
 		return false;
 	return onfieldmas[x][y];
 }
 
 inline bool iscorner(int x, int y)
 {
 	if (x == 1 && y == 1)
 		return true;
 	if (x == s && y == 1)
 		return true;
 	if (x == 1 && y == s)
 		return true;
 	if (x == 2 * s - 1 && y == 2 * s - 1)
 		return true;
 	if (x == s && y == 2 * s - 1)
 		return true;
 	if (x == 2 * s - 1 && y == s)
 		return true;
 	return false;
 }
 
 inline bool isedge(int x, int y)
 {
 	if (x == 1 || y == 1 || x == 2 * s - 1 || y == 2 * s - 1 || abs(x - y) == s - 1)
 		return true;
 	return false;
 }
 
 void doonfield()
 {
 	for (int i = 0; i < size; i++)
 		for (int j = 0; j < size; j++)
 			onfieldmas[i][j] = false;
 	for (int i = 1; i <= s; i++)
 		for (int j = 1; j <= s + i - 1; j++)
 			onfieldmas[i][j] = true;
 	for (int i = 1; i < s; i++)
 		for (int j = 1 + i; j <= 2 * s - 1; j++)
 			onfieldmas[i + s][j] = true;
 	corners.clear();
 	corners.pb(mp(1, 1));
 	corners.pb(mp(1, s));
 	corners.pb(mp(s, 1));
 	corners.pb(mp(2 * s - 1, 2 * s - 1));
 	corners.pb(mp(2 * s - 1, s));
 	corners.pb(mp(s, 2 * s - 1));
 }
 
 void prepare_field(int k)
 {
 	for (int i = 0; i <= 2 * s; i++)
 		for (int j = 0; j <= 2 * s; j++)
 			busy[i][j] = false;
 	for (int i = 0; i < k; i++)
 		busy[x[i]][y[i]] = true;
 }
 
 void make_unused()
 {
 	for (int i = 0; i <= 2 * s; i++)
 		for (int j = 0; j <= 2 * s; j++)
 			used[i][j] = false;
 }
 
 void dfs(int x, int y)
 {
 	used[x][y] = true;
 	for (int i = 0; i < 6; i++)
 		if (onfield(x + px[i], y + py[i]) && !busy[x + px[i]][y + py[i]] && !used[x + px[i]][y + py[i]])
 			dfs(x + px[i], y + py[i]);
 }
 
 void dfs_busy(int x, int y)
 {
 	used[x][y] = true;
 	for (int i = 0; i < 6; i++)
 		if (onfield(x + px[i], y + py[i]) && busy[x + px[i]][y + py[i]] && !used[x + px[i]][y + py[i]])
 			dfs_busy(x + px[i], y + py[i]);
 }
 
 int edgenum(int x, int y)
 {
 	if (x == 1)
 		return 1;
 	if (y == 1)
 		return 2;
 	if (x - y == s - 1)
 		return 3;
 	if (y - x == s - 1)
 		return 4;
 	if (x == 2 * s - 1)
 		return 5;
 	if (y == 2 * s - 1)
 		return 6;
 	assert(false);
 }
 
 void dfs_edges(int x, int y)
 {
 	used[x][y] = true;
 	if (isedge(x, y) && !iscorner(x, y))
 		edges.insert(edgenum(x, y));
 	for (int i = 0; i < 6; i++)
 		if (onfield(x + px[i], y + py[i]) && busy[x + px[i]][y + py[i]] && !used[x + px[i]][y + py[i]])
 			dfs_edges(x + px[i], y + py[i]);
 }
 
 bool isring()
 {
 	make_unused();
 	for (int i = 1; i < 2 * s; i++)
 		for (int j = 1; j < 2 * s; j++)
 			if (onfield(i, j) && isedge(i, j) && !busy[i][j] && !used[i][j])
 				dfs(i, j);
 	for (int i = 1; i < 2 * s; i++)
 		for (int j = 1; j < 2 * s; j++)
 			if (onfield(i, j) && !busy[i][j] && !used[i][j])
 				return true;
 	return false;
 }
 
 bool isbridge()
 {
 	make_unused();
 	for (int i = 0; i < 6; i++)
 		if (busy[corners[i].fs][corners[i].sc])
 			if (used[corners[i].fs][corners[i].sc])
 				return true;
 			else
 				dfs_busy(corners[i].fs, corners[i].sc);
 	return false;
 }
 
 bool isfork()
 {
 	make_unused();
 	for (int i = 1; i < 2 * s; i++)
 		for (int j = 1; j < 2 * s; j++)
 			if (onfield(i, j) && busy[i][j] && !used[i][j])
 			{
 				edges.clear();
 				dfs_edges(i, j);
 				if (edges.size() >= 3)
 					return true;
 			}
 	return false;
 }
 
 int check(int mid)
 {
 	int ans = 0;
 	prepare_field(mid);
 	if (isring())
 		ans += 1;
 	if (isbridge())
 		ans += 2;
 	if (isfork())
 		ans += 4;
 	return ans;
 }
 
 string tores(int res, int move)
 {
 	if (res == 0)
 		return "none";
 	char buf[100];
 	for (int i = 0; i < 100; i++)
 		buf[i] = '\0';
 	sprintf(buf, "%d", move);
 	string h(buf);
 	if (res == 1)
 		return "ring in move " + h;
 	if (res == 2)
 		return "bridge in move " + h;
 	if (res == 3)
 		return "bridge-ring in move " + h;
 	if (res == 4)
 		return "fork in move " + h;
 	if (res == 5)
 		return "fork-ring in move " + h;
 	if (res == 6)
 		return "bridge-fork in move " + h;
 	if (res == 7)
 		return "bridge-fork-ring in move " + h;
 	assert(false);
 }
 
 int main() {
 	int tc;
 	int lb, rb, mid;
 
 	freopen("problem_bb.in", "r", stdin);
 	freopen("problem_bb.out", "w", stdout);
 	
 	cin >> tc;
 	for (int t = 0; t < tc; t++)
 	{
 		cin >> s >> n;
 		doonfield();
 		for (int i = 0; i < n; i++)
 			cin >> x[i] >> y[i];
 		lb = 0;
 		rb = n;
 		while (lb < rb)
 		{
 			mid = (lb + rb) / 2;
 			if (check(mid) != 0)
 				rb = mid;
 			else
 				lb = mid + 1;
 		}
 		cout << "Case #" << t + 1 << ": " << tores(check(lb), lb) << endl;
 	}
 
 	return 0;
 }