#include<stdio.h>
 #include<string.h>
 #include<stdlib.h>
 #include<iostream>
 #include<algorithm>
 using namespace std;
 
 int n,m;
 int s[610][610],p[610][610];
 bool ring, fork, bridge;
 
 inline bool inside(int x, int y){
 	if(y < max(1,x-n+1) || y > min(n*2-1,x+n-1) || x < max(1, y-n+1) || x > min(n*2-1,y+n-1))
 		return false;
 	return true;
 }
 inline int inedge(int x,int y){
 	if(x==1 && (y!=1 || y!=n))return 0;
 	if(y==1 && (x!=1 || x!=n))return 1;
 	if(y>1 && y<n && x-y==n-1)return 2;
 	if(x>1 && x<n && y-x==n-1)return 3;
 	if(x==n*2-1 && y>n && y<n*2-1) return 4;
 	if(y==n*2-1 && x>n && x<n*2-1) return 5;
 	return -1;
 }
 
 int step;
 int dx[6] = {0,0,-1,1,-1,1};
 int dy[6] = {-1,1,0,0,-1,1};
 bool findring(int x, int y){
 	if(!inside(x, y))
 		return false;
 	//fprintf(stderr,"%d %d \n",x,y);
 	if(p[x][y] != 0 && p[x][y] <= step)
 		return true;
 	p[x][y] = -1;
 	for(int i=0;i<6;i++)
 		if(!findring(x+dx[i], y+dy[i]))
 			return false;
 	return true;
 }
 bool findfork(int x, int y, int& edge){
 	if(!inside(x, y))
 		return false;
 	if(p[x][y] <= 0 || p[x][y] > step)
 		return false;
 	p[x][y] = -1;
 	int z = inedge(x,y);
 	if(z >= 0)
 		edge = (edge | (1 << z));
 	//fprintf(stderr,"%d %d %d\n",x,y,edge);
 	for(int i=0;i<6;i++)
 		if(findfork(x+dx[i], y+dy[i], edge))
 			return true;
 	int k=0;
 	for(int i=0;i<6;i++)
 		k += ((edge&(1<<i))>0);
 	return k>=3;
 }
 void findbridge(int x, int y){
 	if(!inside(x, y))
 		return;
 	if(p[x][y] <= 0 || p[x][y] > step)
 		return;
 	p[x][y] = -1;
 	for(int i=0;i<6;i++)
 		findbridge(x+dx[i], y+dy[i]);
 }
 void check(){
 	ring = fork = bridge = false;
 	//cerr << "ring" << endl;
 	memcpy(p, s, sizeof(s));
 	for(int i=1;i<=n*2-1 && !ring;i++)
 		for(int j=max(1,i-n+1);j<min(n*2-1,i+n-1) && !ring;j++)
 			if((p[i][j]==0 || p[i][j]>step) && findring(i,j))
 				ring = true;
 
 	//cerr << "fork" << endl;
 	memcpy(p, s, sizeof(s));
 	for(int i=2;i<n && !fork;i++){
 		int h=0;
 		if(findfork(i, 1, h))
 			fork = true;
 		else if(findfork(1, i, h=0))
 			fork = true;
 		else if(findfork(i+n-1, i, h=0))
 			fork = true;
 		else if(findfork(i, i+n-1, h=0))
 			fork = true;
 		else if(findfork(n*2-1, i+n-1, h=0))
 			fork = true;
 		else if(findfork(i+n-1, n*2-1, h=0))
 			fork = true;
 	}
 	
 	//cerr << "bridge" << endl;
 	memcpy(p, s, sizeof(s));
 	findbridge(1,1);
 	if(p[1][n] < 0)
 		bridge = true;
 	else{
 		findbridge(1,n);
 		if(p[n][1] < 0)
 			bridge = true;
 		else{
 			findbridge(n,1);
 			if(p[n*2-1][n*2-1] < 0)
 				bridge = true;
 			else{
 				findbridge(n*2-1,n*2-1);
 				if(p[n*2-1][n] < 0)
 					bridge = true;
 				else{
 					findbridge(n*2-1,n);
 					if(p[n][n*2-1] < 0)
 						bridge = true;
 				}
 			}
 		}
 	}
 }
 int main(void){
 	int t,x,y;
 	scanf("%d",&t);
 	for(int tt=1;tt<=t;tt++){
 		scanf("%d%d",&n,&m);
 		memset(s,0,sizeof(s));
 		for(int i=1;i<=m;i++){
 			scanf("%d%d",&x,&y);
 			s[x][y] = i;
 		}
 		
 		bool rf=0,ff=0,bf=0;
 		int st = 1, ed = m, ans;
 		while(st <= ed){
 			//fprintf(stderr,"%d: %d %d\n",tt,st,ed);
 			step = (st+ed)/2;
 			check();
 			if(ring || fork || bridge){
 				ed = step-1;
 				ans = step;
 				rf = ring;
 				bf = bridge;
 				ff = fork;
 			}
 			else
 				st = step+1;
 		}
 		
 		fprintf(stderr, "%d\n", tt);
 		//printf("Case #%d: %d %d %d\n", tt,rf,bf,ff);
 		printf("Case #%d: ", tt);
 		if(!rf && !bf && !ff)
 			puts("none");
 		else{
 			if(bf)
 				printf("bridge");
 			if(ff)
 				printf(bf?"-fork":"fork");
 			if(rf)
 				printf(bf||ff?"-ring":"ring");
 			printf(" in move %d\n", ans);
 		}
 	}
 	return 0;
 }
