#include <cstdio>
 #include <vector>
 #include <string>
 #include <cmath>
 #include <algorithm>
 #include <queue>
 #include <cstring>
 #include <cstdlib>
 #include <set>
 #include <map>
 
 using namespace std;
 
 int dbg;
 string readLine();
 int readIntLine();
 vector<int> readVI(int n);
 vector<double> readVD(int n);
 vector<string> readVS(int n);
 vector<int> itokens(string s, string sep);
 vector<string> stokens(string s, string sep);
 
 double  solveIt(int A, int B, const vector<double> &p) {
 	double minp = B+2;
 //	printf("minp %g\n", minp);
 	double pc = 1.0;
 	for (int i = 0; i <= A; i++) {
 		int sc = (A-i) + (B-i) + 1;
 		int sw = sc + B+1;
 		double es = pc*sc + (1.0-pc)*sw;
 //		printf("i %d - es %g\n", i, es);
 		if (es < minp) minp = es;
 		pc *= p[i];
 	}
 	return minp;
 }
 
 int main(int argc, char ** /*argv*/) {
 	dbg = argc;
 	int CCT = readIntLine();
 	for (int cn = 1; cn <= CCT; cn++) {
 		int A, B;
 		scanf("%d %d ", &A, &B);
 		vector<double> p = readVD(A);
 
 		double res = solveIt(A, B, p);
 		printf("Case #%d: %.10lf\n", cn, res);
 	}
 	return 0;
 }
 
 
 
 
 
 
 
 
 string readLine() {
 	char sz[1000];
 	fgets(sz, 1000, stdin);
 	int l = strlen(sz);
 	if (sz[l-1] == '\n') sz[l-1] = 0;
 	return sz;
 }
 int readIntLine() {
 	string s = readLine();
 	return atoi(s.c_str());
 }
 vector<double> readVD(int n = 0) {
 	if (!n) scanf("%d ", &n);
 	vector<double> v(n);
 	for (int i = 0; i < n; i++) scanf("%lf ", &v[i]);
 	return v;
 }
 vector<int> readVI(int n = 0) {
 	if (!n) scanf("%d ", &n);
 	vector<int> v(n);
 	for (int i = 0; i < n; i++) scanf("%d ", &v[i]);
 	return v;
 }
 vector<string> readVS(int n = 0) {
 	if (!n) scanf("%d ", &n);
 	vector<string> v(n);
 	for (int i = 0; i < n; i++) v[i] = readLine();
 	return v;
 }
 vector<string> stokens(string s, string sep = " \n\r\t") {
 	vector<string> res;
 	int start, end = 0;
 	while ((start = s.find_first_not_of(sep, end)) != string::npos) {
 		end = s.find_first_of(sep, start);
 		res.push_back(s.substr(start, end-start));
 	}
 	return res;
 }
 vector<int> itokens(string s, string sep = " \n\r\t") {
 	vector<int> res;
 	int start, end = 0;
 	while ((start = s.find_first_not_of(sep, end)) != string::npos) {
 		end = s.find_first_of(sep, start);
 		res.push_back(atoi(s.substr(start, end-start).c_str()));
 	}
 	return res;
 }
 
