/* Problem: http://code.google.com/codejam/contest/1645485/dashboard#s=p0 */
 
 #include <stdio.h>
 
 
 int main(int argc, char* argv[])   /* usage: progname [file.in [file.out]] */
 {
 	FILE  *in  = stdin;
 	FILE  *out = stdout;
 	
 	int     T;   /* number of cases */
 	int     X;   /* current case */
 	double  Y;   /* case result */
 
 	int     A;           /* number of characters already typed */
 	int     B;           /* total number of characters in password */
 	double  p[100000];   /* p[i] = probability I written correctly the letter i (counting from 1) */
 
 	double  c[100000];      /* c[f] = probabilities i written correctly up to letter keys including */
 	double  keystr;         /* expected number of keystrokes */
 	double  min_keystr;     /* min number of keystrokes */
 	double  bad_p, good_p;  /* bad and good chances for password */
 	int     crt_keystr;
 
 	int  i, keys, scanned;   /* indices */
 
 
 	switch(argc) {
 	case 3:
 		out = fopen(argv[2], "w");
 		if (out == NULL) {
 			fprintf(stderr, "Cannot open output file \"%s\".\n", argv[2]);
 			return 1;
 		}
 		/* fall trough */
 	case 2:
 		in = fopen(argv[1], "r");
 		if (in == NULL) {
 			fprintf(stderr, "Cannot open input file \"%s\".\n", argv[1]);
 			return 2;
 		}
 		/* fall trough */
 	case 1:
 		break;
 	default:
 		fprintf(stderr, "Usage:\n\t%s [file.in [file.out]]\n", argv[0]);
 		return 3;
 	}
 
 	scanned = fscanf(in, "%d", &T);
 	if(scanned != 1) {
 		fprintf(stderr, "Cannot read number of cases.\n");
 		return 4;
 	}
 	if(T<1 || T>20) {
 		fprintf(stderr, "Number of cases out of bounds.\n");
 		return 5;
 	}
 
 	for(X=1; X<=T; ++X) {
 		scanned = fscanf(in, "%d%d", &A, &B);
 		if (scanned != 2) {
 			fprintf(stderr, "Cannot read one of the pass counts A, B on case %d.\n", X);
 			return 6;
 		}
 		if(A<1 || A>99999) {
 			fprintf(stderr, "A is out of bounds on case %d.\n", X);
 			return 7;
 		}
 		if(B<=A || B>100000) {
 			fprintf(stderr, "B is out of bounds on case %d.\n", X);
 			return 8;
 		}
 		for(i=1; i<=A; ++i) {
 			scanned = fscanf(in, "%lf", &p[i]);
 			if(scanned != 1) {
 				fprintf(stderr, "Cannot read p[%d] on case %d.\n", i, X);
 				return 9;
 			}
 		}
 
 		/* compute the combined probabilities */
 		c[0] = 1.0;
 		for(i=1; i<=A; ++i) {
 			c[i] = c[i-1] * p[i];
 		}
 		for(i=0; i<A; ++i) {
 			c[i] = c[i] * (1 - p[i+1]);
 		}
 
 		/* Enter right away */
 		min_keystr = B + 2;
 
 		/* Keep trying */
 		good_p = c[A];
 		bad_p = 1 - c[A];
 		keys = B - A + 1;  /* completed keystrokes */
 		keystr = good_p*keys + bad_p*(keys + B + 1);
 		if(keystr < min_keystr) {
 			min_keystr = keystr;
 		}
 
 		/* i backspaces */
 		for(i=1; i<=A; ++i) {
 			good_p += c[A-i];
 			bad_p  -= c[A-i];
 			keys += 2;
 			keystr = good_p*keys + bad_p*(keys + B + 1);
 			if(keystr < min_keystr) {
 				min_keystr = keystr;
 			}
 		}
 
 		Y = min_keystr;
 		fprintf(out, "Case #%d: %.6f\n", X, Y);
 	}
 
 
 	return 0;
 }
