#include <iostream>
 #include <algorithm>
 #include <vector>
 #include <cstdio>
 #include <cstring>
 #include <cstdlib>
 #include <queue>
 #include <sstream>
 #include <set>
 #include <map>
 #include <cmath>
 using namespace std;
 
 long long cmp[41][41];
 
 void cmp_init(void)
 {
     int j, k, n = 41;
     memset(cmp, 0LL, sizeof(cmp));
     for(j = 0; j < 41; j++){
 	cmp[j][0] = 1LL;
 	cmp[0][j] = 0LL;
 	cmp[j][j] = 1LL;
     }
     for(j = 1; j < 41; j++){
 	for(k = 1; k < j; k++){
 	    cmp[j][k] = cmp[j-1][k] + cmp[j-1][k-1];
 	}
     }
 }
 
 int n, c;
 
 void dfs(int remain, double prob, double cnt, double& ans)
 {
     if(fabs(prob) < 1e-9){
 	return;
     }
     if(remain == 0){
 	if(fabs(prob * cnt) < 1e-9){
 	    //printf("%f prob\n", prob);
 	    return;
 	}
 	else{
 	    ans += prob * cnt;
 	    //printf("cnt %f prob %f avg %f ans %f\n", cnt, prob, prob * cnt, ans);
 	    return;
 	}	
     }
     int j;
     for(j = 0; j <= min(n, remain); j++){
 	dfs(remain - j, 
 		prob * ((double)(cmp[c - remain][n - j] * cmp[remain][j]) /
 		cmp[c][n]), cnt + 1, ans);
     }
 }
 
 int main()
 {
     int t, j, k;
     double ans, cnt;
     scanf("%d", &t);
     cmp_init();
     //for(j = 1; j <= 10; j++){
 	//for(k = 0; k <= j; k++)
 	    //printf("%d ", cmp[j][k]);
 	//printf("\n");
 
     //}
     for(j = 1; j <= t; j++){
 	scanf("%d%d", &c, &n);
 	ans = 0.0;
 	cnt = 0.0;
 	dfs(c, 1.0, cnt, ans);
 	printf("Case #%d: %.7f\n", j, ans);
     }
     return 0;
 }
