#include <vector>
 #include <fstream>
 #include <iostream>
 #include <cmath>
 #include <sstream>
 #include <string>
 #include <iomanip>
 
 using namespace std;
 
 int coinNeeded(int start, int end, vector<int> release)
 {
     if(release.size() == 0)
         return 0;
     else
     {
         int mid = end - start;
         vector<int>::const_iterator best = release.begin();
         vector<int>::iterator itr;
 
         int diff = 0;
         for(itr = release.begin(); itr != release.end(); itr++)
         {
             if(abs(*itr - mid) < abs(*best - mid))
             {
                 best = itr;
                 vector<int>::iterator itr2;
                 for(itr2 = release.begin(); itr2 != release.end(); itr2++)
                 {
                     if(*itr2 < *best)
                         diff--;
                     else if(*itr2 > *best)
                         diff++;
                 }
             }
             if(abs(*itr - mid) == abs(*best - mid))
             { 
                 vector<int>::iterator itr2;
                 int tempDiff = 0;
                 for(itr2 = release.begin(); itr2 != release.end(); itr2++)
                 {
                     if(*itr2 < *best)
                         tempDiff--;
                     else if(*itr2 > *best)
                         tempDiff++;
                 }
                 if(abs(tempDiff) - abs(diff) > 0)
                 {
                     best = itr;
                     vector<int>::iterator itr2;
                     for(itr2 = release.begin(); itr2 != release.end(); itr2++)
                     {
                         if(*itr2 < *best)
                             diff--;
                         else if(*itr2 > *best)
                             diff++;
                     }
                 }
             }
         }
 
         int pos = *best;
 
         int cost = 0;
 
         vector<int> left;
         vector<int> right;
         for(itr = release.begin(); itr != release.end(); itr++)
         {
             if(*itr < pos)
                 left.push_back(*itr);
             else if(*itr > pos)
                 right.push_back(*itr);
         }
         
         cost += end - start;
         cost += coinNeeded(start, pos - 1, left);
         cost += coinNeeded(pos + 1, end, right);
         return cost;
     }
 }
 
 int main()
 {
     ifstream myFile("problem3.txt");
     FILE* myAnswer;
     myAnswer = fopen("answer3.txt", "w");
     if (myFile.is_open())
     {
         int T;
         myFile >> T;
         string temp;
         getline(myFile, temp);
         
         for(int tc = 1; tc <= T; tc++)
         {
             string nextCase;
             getline(myFile, nextCase);
             stringstream caseStr(nextCase);
             int p;
             int q;
             caseStr >> p;
             caseStr >> q;
             
             string prisonersStr;
             getline(myFile, prisonersStr);
             stringstream prisonerOut(prisonersStr);
             vector<int> prisoners;
             for(int i = 0; i < q; i++)
             {
                 int next;
                 prisonerOut >> next;
                 prisoners.push_back(next);
             }
             fprintf(myAnswer, "Case #%d: %d\n", tc, coinNeeded(1, p, prisoners));
         }
     }
 }