
 #include <list>
 #include <algorithm>
 
 #include <cctype>
 #include <cmath>
 #include <cstdio>
 #include <cstdlib>
 #include <cstring>
 
 FILE *fi;		// input file
 FILE *fo; 		// output file
 
 int cases;		// number of cases
 int cas; 		// actual case
 
 char chara[1];
 
 int prison[10050];
 
 int qs[100];
 int ord[100];
 
 struct node
 {
  int ind;
  int value;
  node *prev;
  node *next;
 };
 
 node table[100][100];
 
 int cells;
 int frees;
 
 int bribes;
 
 void init(node *from)
 {
  for (int i=0; i<10050; i++)
   prison[i] = ((i>=1) && (i<=cells)? 1 : 0);
 
  while (from)
  {
   prison[qs[from->ind]] = 0;
 
   from = from->prev;
  }
 }
 
 int count(int from, int dir)
 {
  int res = 0;
  for (int i=from+dir; prison[i]; i+=dir) res++;
  return res;
 }
 
 int main(int argc,char **argv)
 {
  if (argc!=2) { printf("Nincs input!\n"); return 0; }
  fi = fopen(argv[1],"r");
  fo = fopen("output.file","w");
 
  fscanf(fi,"%d",&cases);
 
  for (cas=1; cas<=cases; cas++)
  {
   // ------------------------------------------------------------------------------
   fscanf(fi,"%d %d",&cells,&frees);
 
   for (int i=0; i<10050; i++)
    prison[i] = ((i>=1) && (i<=cells)? 1 : 0);
 
   bribes = 0;
   for (int i=0; i<frees; i++)
   {
    fscanf(fi,"%d",qs+i);
 
    for (int j=0; j<100; j++) 
    {
     table[j][i].ind = i;
     table[j][i].value = -1;
    }
 
    table[0][i].prev = 0;
    table[0][i].value = cells-1;
   }
 
   for (int i=1; i<frees; i++)
   {
    
    for (int j=0; j<frees; j++)
    {
     int sum = -1;
     int ind = -1;
 
     for (int k=0; k<frees; k++)
     {
      init(&table[i-1][k]);
      if (!prison[qs[j]]) continue;
      int sum2 = table[i-1][k].value;
 
      sum2 += count(qs[j],+1) + count(qs[j],-1);
 
      if ((sum2 < sum) || (ind == -1))
      {
       sum = sum2;
       ind = k;
      }
     }
     
     table[i][j].value = sum;
     table[i][j].prev = &table[i-1][ind];
 
     printf("%d ",sum);
    }
    printf("\n");
   }
   printf("\n");
 
   int goals = -1;
   int goal = -1;
   for (int i=0; i<frees; i++)
    if ((table[frees-1][i].value != -1) && ((table[frees-1][i].value<goals) || (goal == -1)))
    {
     goal = i;
     goals = table[frees-1][i].value;
    }
 
   printf("goal: %d\n",goal);
 
   fprintf(fo,"Case #%d: %d\n",cas,table[frees-1][goal].value);
   // ------------------------------------------------------------------------------
  }
 
  fclose(fi);
  fclose(fo);
  return 0;
 }
 
 
