#include <vector>
 #include <iostream>
 #include <algorithm>
 #include <cassert>
 
 using namespace std;
 
 struct Segment {
 	bool prisoner;
 	Segment *prev;
 	Segment *next;
 	long long count;
 	Segment() {
 		prisoner = true;
 		count = 0;
 		prev = NULL;
 		next = NULL;
 	}
 	Segment(long long c) {
 		count = c;
 		prisoner = false;
 		prev = NULL;
 		next = NULL;
 	}
 	long long getVal() {
 		long long res = 0;
 		if (prev != NULL) {
 			res += prev->count;
 		}
 		if (next != NULL) {
 			res += next->count;
 		}
 		return res;
 	}
 	long long getTotalVal() {
 		long long res = 0;
 		Segment *p = prev;
 		while (p != NULL) {
 			res += p->count;
 			p = p->prev;
 		}
 		Segment *n = next;
 		while (n != NULL) {
 			res += n->count;
 			n = n->next;
 		}
 		return res;
 	}
 	void contract() {
 		assert(prisoner);
 		long long total = 1;
 		if (prev != NULL && !prev->prisoner) {
 			total += prev->count;
 			Segment *nextPrev = prev->prev;
 			if (nextPrev != NULL)
 				nextPrev->next = this;
 			delete prev;
 			prev = nextPrev;
 		}
 		if (next != NULL && !next->prisoner) {
 			total += next->count;
 			Segment *nextNext = next->next;
 			if (nextNext != NULL)
 				nextNext->prev = this;
 			delete next;
 			next = nextNext;
 		}
 		prisoner = false;
 		count = total;
 	}
 };
 
 class Comp {
 public:
 	bool operator()(Segment * const& a, Segment *const &b) {
 		long long aval = a->getVal();
 		long long bval = b->getVal();
 		if (aval != bval) return aval < bval;
 		return a->getTotalVal() < b->getTotalVal();
 	}
 };
 
 int main() {
 	int T;
 	cin >> T;
 	for (int t = 1; t <= T; t++) {
 		int P, Q;
 		cin >> P >> Q;
 		Segment *head = NULL;
 		Segment *tail = NULL;
 		int last = 0;
 		vector<Segment *> v;
 		for (int q = 0; q < Q; q++) {
 			int cur;
 			cin >> cur;
 			cur--; // 1-based
 			int prevSize = cur - last;
 			if (prevSize <= 0) {
 				Segment *s = new Segment();
 				s->prev = tail;
 				if (tail == NULL) {
 					head = tail = s;
 				} else {
 					tail->next = s;
 					tail = s;
 				}
 				v.push_back(s);
 			} else {
 				Segment *s = new Segment(prevSize);
 				s->prev = tail;
 				if (tail == NULL) {
 					head = tail = s;
 				} else {
 					tail->next = s;
 				}
 				s->next = new Segment();
 				v.push_back(s->next);
 				s->next->prev = s;
 				tail = s->next;
 			}
 			last = cur + 1;
 		}
 		if (last < P) {
 			Segment *s = new Segment(P - last);
 			s->prev = tail;
 			tail->next = s;
 			tail = s;
 		}
 		unsigned int i = 0;
 		long long ans = 0;
 		while (v.size() > i) {
 			sort(v.begin() + i, v.end(), Comp());
 			Segment *s = *(v.begin() + i);
 			i++;
 			ans = ans + s->getVal();
 			
 			s->contract();
 		}
 		cout << "Case #" << t << ": " << ans << endl;
 	}
 	return 0;
 }