#include <vector>
 #include <list>
 #include <algorithm>
 #include <iostream>
 #include <fstream>
 #include <iomanip>
 #include <string>
 #include <cassert>
 
 using namespace std;
 
 int main()
 {
 	ifstream in("input.txt");
 
 	int case_count;
 	in >> case_count;
 
 	ofstream out("output.txt");
 
 	for (int case_index = 0; case_index < case_count; ++case_index)
 	{
 		int cell_count, release_count;
 		in >> cell_count >> release_count;
 		vector<int> release_queue(release_count);
 		for (int release_index = 0; release_index < release_count; ++release_index)
 		{
 			in >> release_queue[release_index];
 			--release_queue[release_index];
 		}
 
 		sort(release_queue.begin(), release_queue.end());
 
 		vector<bool> occupied(cell_count);
 		fill(occupied.begin(), occupied.end(), true);
 		int total_cost = 0;
 		for (int day = 0; day < release_count; ++day)
 		{
 			int max_cutoff = -1;
 			int max_index = -1;
 			int cost = 0;
 			int max_offset = 0;
 
 			for (int release_queue_pos = 0, release_queue_count = int(release_queue.size()); release_queue_pos < release_queue_count; ++release_queue_pos)
 			{
 				int cutoff_left = 0;
 				for (int pos = release_queue[release_queue_pos] - 1; pos >= 0 && occupied[pos]; --pos)
 					++cutoff_left;
 				int cutoff_right = 0;
 				for (int pos = release_queue[release_queue_pos] + 1; pos < cell_count && occupied[pos]; ++pos)
 					++cutoff_right;
 
 				int cutoff = (std::min)(cutoff_left, cutoff_right);
 				int offset = release_queue_pos - release_queue.size() / 2;
 				if (cutoff > max_cutoff || (cutoff == max_cutoff && max_offset < offset))
 				{
 					max_cutoff = cutoff;
 					max_index = release_queue_pos;
 					cost = cutoff_left + cutoff_right;
 					max_offset = release_queue_pos - release_queue.size() / 2;
 				}
 			}
 
 			occupied[release_queue[max_index]] = false;
 			total_cost += cost;
 			release_queue.erase(release_queue.begin() + max_index);
 		}
 
 		out << "Case #" << case_index + 1 << ": " << total_cost << "\n";
 	}
 
 	return 0;
 }
