#include <algorithm>
 #include <iostream>
 #include <iomanip>
 #include <cstdio>
 #include <vector>
 #include <string>
 #include <cmath>
 #include <map>
 #include <set>
 
 using namespace std;
 
 const int P = 10007;
 
 int H, W, R;
 vector< pair < int, int > > z;
 int fact[100000001];
 
 void read_data () {
 	z.clear ();
 	cin >> H >> W >> R;
 	int r, c;
 	for (int i = 0; i < R; ++i) { cin >> r >> c; z.push_back (make_pair (r, c)); }
 }
 
 int m_div (int a, int b) {
 	int res = 1;
 
 	for (int i = 16; i >= 0; --i) {
 		res = (res*res) % P;
 		if ((P-2) & (1 << i)) res = (res*b) % P;
 	}
 
 	return (res*a) % P;
 }
 
 int calc (int W, int H) {
 	if ((W+H-2) % 3 != 0) return 0;
 	if (2*W < H+1 || 2*H < W+1) return 0;
 
 	int nA = (2*W-H-1)/3, nB = (2*H-W-1)/3;
 
 	int ntA = nA, ntAP = 0; while (ntA > 0) { ntAP += ntA/P; ntA /= P; }
 	int ntB = nB, ntBP = 0; while (ntB > 0) { ntBP += ntB/P; ntB /= P; }
 	int ntS = (nA+nB), ntSP = 0; while (ntS > 0) { ntSP += ntS/P; ntS /= P; }
 
 	if (ntAP+ntBP < ntSP) return 0;
 	return m_div (m_div (fact[nA+nB], fact[nA]), fact[nB]);
 }
 
 void solve () {
 	sort (z.begin (), z.end ());
 
 	int ans = 0;
 
 	for (int mask = 0; mask < (1 << R); ++mask) {
 		int k = 0, pi = 1, pj = 1, good = 1, tres = 1;
 		for (int j = 0; j < R; ++j)
 			if (mask & (1 << j)) {
 				++k;
 				if (z[j].first < pi || z[j].second < pj) { good = 0; break; }
 				tres = (tres * calc (z[j].first-pi+1, z[j].second-pj+1)) % P;
 				pi = z[j].first; pj = z[j].second;
 			}
 
 			if (H < pi || W < pj) good = 0; else tres = (tres * calc (H-pi+1, W-pj+1)) % P;
 
 		if (good) {
 			if (k % 2)
 				ans = (ans + P - tres) % P;
 			else
 				ans = (ans + tres) % P;
 		}
 	}
 
 	cout << ans << endl;
 }
 
 int main () {
 	freopen ("D-large.in", "r", stdin);
 
 	fact[0] = 1;
 	for (int i = 1; i <= 100000000; ++i)
 		if (i % P != 0) fact[i] = ((long long)fact[i-1] * i) % P; else fact[i] = fact[i-1];
 
 	int T;
 	cin >> T;
 
 	for (int t = 0; t < T; ++t) {
 		cout << "Case #" << t+1 << ": ";
 
 		read_data ();
 		solve ();
 	}
 
 	return 0;
 }
