#include <string>
 #include <vector>
 #include <algorithm>
 #include <map>
 #include <set>
 #include <sstream>
 #include <iostream>
 #include <queue>
 //#include <cmath>
 
 #define mp make_pair
 #define sz(v)((int)((v).size()))
 #define all(v) v.begin(),v.end()
 #define pb push_back
 
 using namespace std;
 
 typedef pair<int,int> ii;
 typedef long long int64;
 typedef vector<int> vi;
 
 template<class T> T abs(T x){return x>0 ? x:(-x);}
 template<class T> T sqr(T x){return x*x;}
 
 typedef double D;
 
 const double eps=1E-9;
 
 struct point
 {
 	D x,y;
 	point(){}
 	point(D x,D y):x(x),y(y){}
 	point operator-(point p)
 	{
 		return point(x-p.x,y-p.y);
 	}
 	point operator+(point p)
 	{
 		return point(x+p.x,y+p.y);
 	}
 	point operator*(D d)
 	{
 		return point(x*d,y*d);
 	}
 	D operator*(point p)
 	{
 		return x*p.x+y*p.y;
 	}
 	D operator^(point p)
 	{
 		return x*p.y-y*p.x;
 	}
 	D len2()
 	{
 		return x*x+y*y;
 	}
 	void read()
 	{
 		cin >> x >> y;
 	}
 };
 
 bool inside(point a,point b,point c,point p)
 {
 	D s1=abs((a-p)^(b-p))+abs((b-p)^(c-p))+abs((c-p)^(a-p));
 	D s2=((a-p)^(b-p))+((b-p)^(c-p))+((c-p)^(a-p));
 	s2=abs(s2);
 	if(abs(s1)<eps)
 		cerr << "Warn: sq\n";
 	return abs(s1-s2)<eps;
 }
 
 point solve(point a1,point a2,D l1,D l2)
 {
 	return a1*l1+a2*l2;
 	l1*=a1.len2();
 	l2*=a2.len2();
 	point l(l1,l2);
 	point b1(a1.x,a2.x);
 	point b2(a1.y,a2.y);
 	D det=(b1^b2);
 	D dx=(l^b2);
 	D dy=(b1^l);
 	if(abs(det)<eps)
 		cerr << "unsolv\n";
 	return point(dx/det,dy/det);
 }
 
 point get(point b1,point b2,point l)
 {
 	D det=(b1^b2);
 	D dx=(l^b2);
 	D dy=(b1^l);
 	if(abs(det)<eps)
 		cerr << "unsolv\n";
 	if((l-b1*(dx/det)-b2*(dy/det)).len2()>eps)
 		cerr << "!!!!!!!!!!\n";
 	return point(dx/det,dy/det);
 }
 
 int main()
 {
 	int tc;
 	cin >> tc;
 	for(int ic=0;ic<tc;ic++){
 		printf("Case #%d: ",ic+1);
 		point a[3],_b[3],c[3];
 		for(int i=0;i<3;i++)
 			a[i].read();
 		for(int i=0;i<3;i++)
 			_b[i].read();
 		vi v;
 		while(abs((a[1]-a[0])*(a[2]-a[0]))>eps)
 			rotate(a,a+1,a+3),rotate(_b,_b+1,_b+3);
 		if((a[1]-a[0]).len2()<eps || (a[2]-a[0]).len2()<eps)
 			cerr << "warn!\n";
 		for(int i=0;i<3;i++)
 		{
 			v.push_back(i);
 			point p=_b[i]-a[0];
 			//c[i].x=(p*(a[1]-a[0]))/((a[1]-a[0]).len2());
 			//c[i].y=(p*(a[2]-a[0]))/((a[2]-a[0]).len2());
 			c[i]=get(a[1]-a[0],a[2]-a[0],p);
 		}
 		{
 			point cur[3];
 			for(int i=0;i<3;i++)
 				cur[i]=a[i];
 			for(int it=0;it<1000;it++)
 			{
 				point b[3];
 				for(int i=0;i<3;i++)
 				{
 					b[i]=cur[0]+(cur[1]-cur[0])*c[i].x+(cur[2]-cur[0])*c[i].y;
 				}
 				for(int i=0;i<3;i++)
 					cur[i]=b[i];
 			}
 			printf("%.9lf %.9lf\n",cur[0].x,cur[0].y);
 			continue;
 		}
 		vector<point> res;
 		do
 		{
 			point b=c[v[0]];
 			point x1=c[v[1]]-b;
 			point x2=c[v[2]]-b;
 			x1.x-=1.0;
 			x2.y-=1.0;
 			D det=(x1^x2);
 			D dx=-(b^x2);
 			D dy=-(x1^b);
 			if(abs(det)<eps)
 			{
 				cerr << "Warn: det\n";
 				break;
 				continue;
 			}
 			point cur=a[0]+solve((a[1]-a[0]),a[2]-a[0],dx/det,(dy/det));
 			if(inside(_b[0],_b[1],_b[2],cur))
 				res.push_back(cur);
 			break;
 		}
 		while(next_permutation(all(v)));
 		vector<point> w;
 		for(int i=0;i<sz(res);i++)
 		{
 			bool ok=true;
 			for(int j=0;j<sz(w);j++)
 				if(abs(res[i].x-w[j].x)<eps && abs(res[i].y-w[j].y)<eps)
 					ok=false;
 			if(ok)
 				w.push_back(res[i]);
 		}
 		if(sz(w)>1)
 			cerr << "Mnogo\n";
 		if(!sz(w))
 		{
 			printf("No Solution\n");
 			continue;
 		}
 		printf("%.9lf %.9lf\n",w[0].x,w[0].y);
 	}
 	return 0;
 }
