#include <cstdio>
 #include <cstring>
 #include <cmath>
 #include <cstdlib>
 #include <cassert>
 #include <string>
 #include <iostream>
 #include <vector>
 #include <set>
 #include <map>
 #include <algorithm>
 
 typedef long long int64;
 typedef long double real;
 
 #define inf 0x3f3f3f3f
 #define pi (2.0 * acos(0.0))
 #define eps (1e-9L)
 #define Eo(x) { std::cerr << #x << " = " << x << std::endl; }
 
 int x[2][3], y[2][3];
 
 real m[3][3];
 real f[3], u[3];
 real a[2][3][3];
 
 
 bool solve(real a[3][3], real u[3], real f[3]) {
   int i, j, k;
 
   // fprintf(stderr, "!!\n");
   // for(i = 0; i < 3; i++) {
   //   for(j = 0; j < 3; j++)
   //     fprintf(stderr, "%.3lf ", a[i][j]);
   //   fprintf(stderr, "| %.3lf\n", f[i]);
   // }
 
   for(i = 0; i < 3; i++) {
     int bj = i;
     for(j = i+1; j < 3; j++)
       if(fabsl(a[j][i]) > fabsl(a[bj][i]))
 	bj = j;
     if(fabsl(a[bj][i]) < eps) break;
     for(j = i; j < 3; j++)
       std::swap(a[bj][j], a[i][j]);
     std::swap(f[bj], f[i]);
     for(j = i+1; j < 3; j++) {
       real a1 = a[i][i], a2 = a[j][i];
       for(k = i; k < 3; k++)
 	a[j][k] = a[j][k] * a1 - a[i][k] * a2;
       f[j] = f[j] * a1 - f[i] * a2;
     }
   }
   // int oi = i;
 
   // i = oi;
   for(j = i; j < 3; j++) u[j] = 1.0L;
   for(j = i-1; j >= 0; j--) {
     real sum = f[j];
     for(k = j+1; k < 3; k++) sum -= a[j][k] * u[k];
     u[j] = sum / a[j][j];
   }
   // fprintf(stderr, "--\n");
   // for(i = 0; i < 3; i++) {
   //   for(j = 0; j < 3; j++)
   //     fprintf(stderr, "%.3lf ", a[i][j]);
   //   fprintf(stderr, "| %.3lf\n", f[i]);
   // }
   // for(i = 0; i < 3; i++) fprintf(stderr, "%.3lf ", u[i]);
   // fprintf(stderr, "\n\n");
   return true;
 }
 
 inline real vect(real x1, real y1, real x2, real y2) {
   return x1*y2 - x2*y1;
 }
 
 bool inside(real x, real y, real x1, real y1, real x2, real y2, real x3, real y3) {
   real v1 = vect(x-x1, y-y1, x2-x1, y2-y1);
   real v2 = vect(x-x2, y-y2, x3-x2, y3-y2);
   real v3 = vect(x-x3, y-y3, x1-x3, y1-y3);
   if(v1*v2 < -eps || v1*v3 < -eps || v2*v3 < -eps)
     return false;
   return true;
 }
 
 inline real gy(real x) {
   return fabsl(x) < eps ? fabsl(x) : x;
 }
 
 int main() {
   int t, tc;
   scanf("%d", &tc);
   for(t = 1; t <= tc; t++) {
     printf("Case #%d: ", t);
     int i, j, k;
     for(j = 0; j < 2; j++) 
       for(i = 0; i < 3; i++) scanf("%d%d", x[j]+i, y[j]+i);
 
     for(j = 0; j < 2; j++) {
       for(k = 0; k < 3; k++) {
 	for(i = 0; i < 3; i++) {
 	  m[i][0] = x[j][i];
 	  m[i][1] = y[j][i];
 	  m[i][2] = 1.0;
 	  f[i] = (i == k ? 1.0L : 0.0L);
 	}
 	solve(m, u, f);
 	for(i = 0; i < 3; i++)
 	  a[j][k][i] = u[i];
       }
     }
 
     // for(k = 0; k < 2; k++) {
     //   for(i = 0; i < 3; i++, fprintf(stderr, "\n")) 
     // 	for(j = 0; j < 3; j++)
     // 	  fprintf(stderr, "%.3lf ", a[k][i][j]);
     //   fprintf(stderr, "\n");
     // }
 
     for(i = 0; i < 3; i++)
       for(j = 0; j < 3; j++)
 	m[i][j] = a[0][i][j] - a[1][i][j];
     for(i = 0; i < 3; i++) f[i] = 0.0L;
     solve(m, u, f);
     if(fabs(u[2]) > eps) {
       //      Eo("!");
       u[0] /= u[2]; u[1] /= u[2];
       //fprintf(stderr, "!! %.3Lf %.3Lf\n", u[0], u[1]);
       bool f1 = inside(u[0], u[1], x[0][0], y[0][0], x[0][1], y[0][1], x[0][2], y[0][2]);
       bool f2 = inside(u[0], u[1], x[1][0], y[1][0], x[1][1], y[1][1], x[1][2], y[1][2]); 
       //Eo(f1);
       //      Eo(f2);
       if(f1 && f2) {
 	printf("%.6Lf %.6Lf\n", gy(u[0]), gy(u[1]));
 	continue;
       }
     }
     puts("No solution");
   }
   return 0;
 }
