#include <string>
 #include <vector>
 #include <map>
 #include <set>
 #include <queue>
 #include <stack>
 #include <cstdlib>
 #include <cstring>
 #include <cassert>
 #include <iostream>
 #include <sstream>
 #include <cstddef>
 #include <algorithm>
 #include <utility>
 #include <iterator>
 #include <numeric>
 #include <list>
 #include <complex>
 #include <cstdio>
 #include <climits>
 
 using namespace std;
 
 typedef vector<int> vi;
 typedef vector<string> vs;
 typedef long long ll;
 typedef complex<double> pnt;
 typedef pair<int, int> pii;
 
 #define RA(x) (x).begin(), (x).end()
 #define FE(i, x) for (typeof((x).begin()) i = (x).begin(); i != (x).end(); i++)
 #define SZ(x) ((int) (x).size())
 
 template<class T>
 void splitstr(const string &s, vector<T> &out)
 {
     istringstream in(s);
     out.clear();
     copy(istream_iterator<T>(in), istream_iterator<T>(), back_inserter(out));
 }
 
 template<class T> T gcd(T a, T b) { return b ? gcd(b, a % b) : a; }
 
 static int R, C, F;
 static bool grid[60][60];
 
 static int get(int r, int c)
 {
     assert(r >= 0 && r <= R && c >= 0 && c < C);
     return grid[r][c];
 }
 
 static int recurse(int lvl, int here, int cleared)
 {
     if (lvl == R - 1)
         return 0;
 
     int left = min(here, cleared);
     int right = max(here, cleared);
     while (left > 0 && !get(lvl, left - 1))
         left--;
     while (right < C - 1 && !get(lvl, right + 1))
         right++;
 
     int fleft = here;
     int fright = here;
     while (fleft > 0 && get(lvl + 1, fleft - 1))
         fleft--;
     while (fright < C - 1 && get(lvl + 1, fright + 1))
         fright++;
 
     int ans = INT_MAX / 2;
     int burn_min, burn_max;
 
     // burn leftwards
     burn_min = max(left, fleft);
     burn_max = min(fright, right) - 1;
     for (int bright = burn_min; bright <= burn_max; bright++)
     {
         if (bright < left) continue;
         int bottom = lvl + 1;
         while (!get(bottom + 1, bright)) bottom++;
         if (bottom - lvl <= F)
             ans = min(ans, recurse(bottom, bright, bright) + 1);
         if (bottom > lvl + 1)
             continue;
         for (int bleft = burn_min; bleft <= bright; bleft++)
         {
             int cost = bright - bleft + 1;
             ans = min(ans, cost + recurse(lvl + 1, bright, bleft));
         }
     }
 
     // burn rightwards
     burn_min = max(fleft, left) + 1;
     burn_max = min(right, fright);
     for (int bleft = burn_min; bleft <= burn_max; bleft++)
     {
         if (bleft > right) continue;
         int bottom = lvl + 1;
         while (!get(bottom + 1, bleft)) bottom++;
         if (bottom - lvl <= F)
             ans = min(ans, recurse(bottom, bleft, bleft) + 1);
         if (bottom > lvl + 1)
             continue;
         for (int bright = bleft; bright <= burn_max; bright++)
         {
             int cost = bright - bleft + 1;
             ans = min(ans, cost + recurse(lvl + 1, bleft, bright));
         }
     }
 
     // natural drop
     vi drop_spots;
     if (left < fleft) drop_spots.push_back(fleft - 1);
     if (right > fright) drop_spots.push_back(fright + 1);
     for (int i = 0; i < SZ(drop_spots); i++)
     {
         int c = drop_spots[i];
         int bottom = lvl + 1;
         while (bottom < R - 1 && !get(bottom + 1, c))
             bottom++;
         if (bottom - lvl <= F)
             ans = min(ans, recurse(bottom, c, c));
     }
 
     //fprintf(stderr, "lvl = %d  A = %d B = %d   ANS = %d\n", lvl, here, cleared, ans);
     return ans;
 }
 
 int main()
 {
     int cases;
     cin >> cases;
     for (int cas = 0; cas < cases; cas++)
     {
         cin >> R >> C >> F;
         for (int i = 0; i < R; i++)
         {
             string line;
             cin >> line;
             for (int j = 0; j < C; j++)
                 grid[i][j] = line[j] == '#';
         }
         for (int j = 0; j < C; j++)
             grid[R][j] = true;
         int ans = recurse(0, 0, 0);
         if (ans >= INT_MAX / 2)
             printf("Case #%d: NO\n", cas + 1);
         else
             printf("Case #%d: YES %d\n", cas + 1, ans);
     }
     return 0;
 }
