#include <iostream>
 #include <cmath>
 #include <string>
 #include <vector>
 #include <algorithm>
 #include <set>
 #include <map>
 #include <memory.h>
 using namespace std;
 #define sz(c) (int)c.size()
 #define pb push_back
 #define all(c) c.begin(), c.end()
 
 
 void initialize()
 {
     freopen("B0.in","r",stdin);
     freopen("output.txt","w",stdout);
 }
 
 
 const int MAX = 100, INF = (int)1e9;
 char str[MAX];
 
 bool table[MAX][MAX];
 int res[MAX][MAX];
 int n, m;
 
 int Res(int a, int b)
 {
 	if (a >= 0 && a < n && b >= 0 && b < m) return res[a][b];
 	return INF;
 }
 
 int main()
 {
     initialize();
 
 	int T;
 	scanf("%d", &T);
 	for (int t = 1; t <= T; ++t)
 	{
 		int r;
 		scanf("%d%d%d", &n, &m, &r);
 		for (int i = 0; i < n; ++i)
 		{
 			scanf("%s", str);
 			for (int j = 0; j < m; ++j)
 			{
 				if (str[j] == '.')
 					table[i][j] = false;
 				else
 					table[i][j] = true;
 			}
 		}
 
 		for(int i = 0; i < n; ++i)
 			for (int j = 0; j < m; ++j)
 				res[i][j] = INF;
 		{
 			bool ok = true;
 			for (int i = 0; i < m; ++i)
 			{
 				if (table[0][i]) ok = false;
 				if (ok)	res[0][i] = 0;
 			}
 		}
 
 		for (int i = 1; i < n; ++i)
 		{
 			for (int j = 0; j < m; ++j)
 			{
 				if (i + 1 < n && !table[i + 1][j]) continue;
 				int k = i, d = (table[i][j] ? 1 : 0);
 				for (; k >= 1 && i - k < r && !table[k - 1][j]; --k)
 				{
 					res[i][j] = min(res[i][j], min(Res(k - 1, j - 1), Res(k - 1, j + 1)) + d);
 				}
 				if (k > 0 && i - k < r)
 				{
 					if (j > 0 && table[k - 1][j - 1])
 						res[i][j] = min(res[i][j], Res(k - 1, j - 1) + d + 1);
 					if (j + 1 < m && table[k - 1][j + 1])
 						res[i][j] = min(res[i][j], Res(k - 1, j + 1) + d + 1);
 					if (k > 1 && i - k + 1 < r)
 					{
 						res[i][j] = min(res[i][j], Res(k - 2, j + 1) + d + 1);
 						res[i][j] = min(res[i][j], Res(k - 2, j - 1) + d + 1);
 					}
 				}
 				if (!table[i][j])
 					res[i][j] = min(res[i][j], Res(i - 1, j));
 				for (int l = 1; j + l < m && !table[i][j + l]; ++l)
 					res[i][j + l] = min(res[i][j + l], res[i][j]);
 				for (int l = 1; j - l >= 0 && !table[i][j - l]; ++l)
 					res[i][j - l] = min(res[i][j - l], res[i][j]);
 			}
 		}
 
 		int rr = INF;
 		for (int i = 0; i < m; ++i)
 			rr = min(rr, res[n - 1][i]);
 
 		printf("Case #%d: ", t);
 		if (rr == INF)
 			printf("NO\n");
 		else
 			printf("YES %d\n", rr);
 	}
 
     return 0;
 }