#include <iostream>
 #include <map>
 #include <sstream>
 #include <cstdlib>
 #include <string>
 #include <set>
 #include <vector>
 #include <list>
 #include <deque>
 #include <algorithm>
 #include <cmath>
 #include <cstring>
 #include <bitset>
 #include <ctime>
 
 using namespace std;
 
 #define _TEST_TIME
 //#define pi_assert(condition, __VA_ARGS__) if (condition) fprintf(stderr, __VA_ARGS__);
 
 #ifdef _TEST_TIME
 clock_t start_time;
 void print_time()
 {
 	fprintf(stderr, "Time used: %.4lf\n", double(clock() - start_time) / CLOCKS_PER_SEC);
 }
 #endif
 
 int R, C, F;
 int f[60][60][60][60];
 string line[100];
 
 void refresh(int i, int j, int l, int r, int v)
 {
 	for (int d = 1; d < F; ++d)
 	{
 		if (i + 1 == R || line[i + 1][j] == '#')
 		{
 			if (f[i][j][l][r] < 0 || f[i][j][l][r] > v)
 				f[i][j][l][r] = v;
 			break;
 		}
 		++i;
 		l = j; r = j;
 	}
 }
 
 bool ok(int i, int j, int l, int r)
 {
 	return l <= j && j < r || line[i][j] == '.';
 }
 
 void solve()
 {
 	int nCase;
 	cin >> nCase;
 	for (int curCase = 0; curCase < nCase; ++curCase)
 	{
 		cin >> R >> C >> F;
 		for (int i = 0; i < R; ++i) cin >> line[i];
 
 		memset(f, 255, sizeof(f));
 		f[0][0][0][0] = 0;
 		int answer = 100000;
 		for (int i = 0; i < R; ++i)
 			for (int j = 0; j < C; ++j)
 				for (int l = 0; l < C; ++l)
 					for (int r = l; r <= C; ++r) if (f[i][j][l][r] >= 0)
 					{
 						int temp = f[i][j][l][r];
 						if (curCase < 0)
 							printf("f[%d][%d][%d][%d] = %d\n", i, j, l, r, temp);
 						if (i == R - 1)
 						{
 							bool pass = true;
 							for (int k = j; k < C; ++k)
 							{
 								if (k >= l && k < r) continue;
 								if (line[i][k] == '.') continue;
 								pass = false;
 								break;
 							}
 							if (pass)
 								answer = min(answer, temp);
 							continue;
 						}
 
 						int u = j, v = j;
 						while (u > 0 && ok(i, u - 1, l, r) && line[i + 1][u - 1] == '#') --u;
 						while (v < C - 1 && ok(i, v + 1, l, r) && line[i + 1][v + 1] == '#') ++v;
 
 							if (i == 1 && j == 1 && l == 1 && r == 3 && 0)
 								printf("%d %d\n", u, v);
 
 						if (u > 0 && ok(i, u - 1, l, r) && line[i + 1][u - 1] == '.') refresh(i + 1, u - 1, u - 1, u - 1, temp);
 						if (v + 1 < C && ok(i, v + 1, l, r) && line[i + 1][v + 1] == '.') refresh(i + 1, v + 1, v + 1, v + 1, temp);
 
 						for (int nj = u; nj <= v; ++nj)
 						{
 							if (nj < v)
 							{
 								for (int t = nj; t >= u - 1 && t >= 0; --t)
 									refresh(i + 1, nj, t, nj + 1, temp + (nj - t + 1));
 							}
 
 							if (nj > u)
 							{
 								for (int t = nj; t <= v + 1 && t < C; ++t)
 									refresh(i + 1, nj, nj, t + 1, temp + (t - nj + 1));
 							}
 						}
 					}
 		if (answer > R * C)
 			printf("Case #%d: No\n", curCase + 1);	
 		else
 			printf("Case #%d: Yes %d\n", curCase + 1, answer);	
 //		break;
 	}
 }
 
 int	main()
 {
 #ifdef _TEST_TIME
 	start_time = clock();
 #endif
 
 	solve();
 
 #ifdef _TEST_TIME
 	print_time();
 #endif
 	return 0;
 }
