#include <iostream>
 #include <vector>
 #include <string>
 #include <set>
 #include <deque>
 #include <cstring>
 #include <algorithm>
 #include <cassert>
 #include <cstdio>
 
 using namespace std;
 
 int rows, cols, maxfall;
 char map[60][60];
 int val[10][6][1<<6][1<<6];
 const int dc[] = {-1,1};
 
 struct P {
 	int r, c;
 	int n_digs;
 	int free;
 	int digged;
 };
 deque<P> d;
 
 int main() {
 	int cases;
 	
 	scanf( "%d", &cases );
 	for( int caseid = 1; caseid <= cases; ++caseid ) {
 		scanf( "%d%d%d", &rows, &cols, &maxfall );
 		for( int r = 0; r < rows; ++r ) {
 			scanf( "%s", map[r] );
 		}
 		d.clear();
 		d.push_back( (P) { 0, 0, 0, 0, 0 } );
 		
 		memset( val, -1, sizeof(val) );
 		int result = -1;
 		while( !d.empty() ) {
 			P p = d.front();
 			d.pop_front();
 			
 			if( p.r == rows-1 ) {
 				result = p.n_digs;
 				break;
 			}
 			
 			// walk
 			for( int i = 0; i < 2; ++i ) {
 				int c = p.c + dc[i];
 				int r = p.r;
 				if( c >= 0 && c < cols && (map[r][c] == '.' || (p.free & (1<<c))  ) ) {
 					if( map[r+1][c] == '.' || (p.digged & (1<<c)) ) {
 						// fall down
 						int r2;
 						for( r2 = r+2; r2 < rows; ++r2 ) {
 							if( map[r2][c] == '#' ) break;
 						}
 						if( r2-1-r <= maxfall && val[r2-1][c][r2-1-r == 1 ? p.digged : 0][0] == -1 ) {
 							val[r2-1][c][r2-1-r == 1 ? p.digged : 0][0] = 1;
 							d.push_front( (P) { r2-1, c, p.n_digs, r2-1-r == 1 ? p.digged : 0, 0 } );
 						}
 					} else {
 						// do not fall down
 						if( val[r][c][p.free][p.digged] == -1 ) {
 							val[r][c][p.free][p.digged] = 1;
 							d.push_front( (P) { r, c, p.n_digs, p.free, p.digged } );
 						}
 					}
 				}
 			}
 			
 			
 			for( int i = 0; i < 2; ++i ) {
 				int c = p.c + dc[i];
 				int r = p.r;
 				
 				if( c >= 0 && c < cols && (map[r+1][c] == '#' && !(p.digged & (1<<c) ) ) && (map[r][c] == '.' || (p.free & (1<<c)) ) ) {
 					// dig cell (r+1,c)
 					if( val[r][c][p.free][p.digged | (1<<c)] == -1 ) {
 						val[r][c][p.free][p.digged | (1<<c)] = 1;
 						d.push_back( (P) { p.r, p.c, p.n_digs + 1, p.free, p.digged | (1<<c) } );
 					}
 				}
 			}
 		}
 		
 		if( result == -1 ) {
 			printf( "Case #%d: No\n", caseid );
 		} else {
 			printf( "Case #%d: Yes %d\n", caseid, result );
 		}
 	}
 	return 0;
 }
