#include <stdio.h>
 
 long long int powerOfTen(int power)
 {
 	if (power == 0) return 1;
 	else return 10 * powerOfTen(power-1);
 }
 
 int greatestLevel(long long int number, int currentLevel)
 {
 	long long digit = number % 10;
 	long long remainingNumber = number / 10;
 
 	if (remainingNumber == 0) return currentLevel;
 
 	int greatestLevelSoFar = greatestLevel(remainingNumber, currentLevel+1);
 
 	if (digit >= (number / powerOfTen(greatestLevelSoFar - currentLevel)) % 10)
 	{
 		return currentLevel;
 	}
 	else
 	{
 		return greatestLevelSoFar;
 	}
 }
 
 long long int findTidy(unsigned long long int number)
 {
 	long long int digit = number % 10;
 	long long int remainingNumber = number / 10;
 
 	if (remainingNumber == 0) return number;
 
 	int greatestLevelFound = greatestLevel(number, 0);
 
 	if (greatestLevelFound > 0)
 	{
 		return findTidy(remainingNumber - 1) * 10 + 9;
 	}
 	else
 	{
 		return number;
 	}
 }
 
 int main()
 {
 	int testCases, i;
 	long long int n, tidy;
 
 	scanf("%d", &testCases);
 
 	for (i = 0; i < testCases; i++)
 	{
 		scanf("%lld", &n);
 
 		tidy = findTidy(n);
 
 		printf("Case #%d: %lld\n", i+1, tidy);
 	}
 
 	return 0;
 }