#include <stdio.h>
 #define MAX_DIGITS 20
 
 unsigned int
 is_tidy(unsigned int num)
 {
   unsigned int ret = 1;
   unsigned int i;
   char buf[MAX_DIGITS];
   for (i = 0; i < MAX_DIGITS; i++)
     buf[i] = '\0';
   (void)sprintf(buf, "%d", num);
   for (i = 1; i < MAX_DIGITS && buf[i] != '\0'; i++)
     ret = ret && buf[i - 1] <= buf[i];
   return ret;
 }
 
 int
 main()
 {
   FILE* in = fopen("B-small-attempt1.in", "r");
   FILE* out = fopen("out.txt", "w");
   if (in == NULL || out == NULL)
   {
     (void)fclose(in);
     (void)fclose(out);
     return 0;
   }
   unsigned int num_cases;
   if (fscanf(in, "%d\n", &num_cases) != 1)
   {
     (void)fclose(in);
     (void)fclose(out);
     return 0;
   }
   unsigned int i;
   for (i = 0; i < num_cases; i++)
   {
     unsigned int curr;
     (void)fscanf(in, "%d\n", &curr);
     while (!is_tidy(curr)) curr--;
     (void)fprintf(out, "Case #%d: %d\n", i + 1, curr);
   }
   (void)fclose(in);
   (void)fclose(out);
   return 0;
 }
