#define _CRT_SECURE_NO_WARNINGS
 #include <stdio.h>
 #include <stdlib.h>
 
 /*Function which given a number, checks if it is tidy, i.e. all its numbers from right to left 
 are in descending order. 
 Function returns a 1 if it is tidy and 0 if it is not*/
 int isTidyNumber(int number)
 {
 	int isTidy = 1;
 	int lastDigit = 10;
 	//split the number into digits from right to left
 	while (number > 0)
 	{
 		int digit = number % 10;
 		if (digit > lastDigit)
 		{
 			isTidy = 0;
 			break;
 		}
 		
 		lastDigit = digit;
 		number = number / 10;
 	}
 	
 	return(isTidy);
 }
 
 int main(int argc, char *argv[])
 {
 	//first read the file
 	FILE *fp = fopen("Text.txt", "r");
 	if (!fp)
 	{
 		printf("Error opening file\n");
 		exit(0);
 	}
 	
 	//read how many lines there are
 	int numLines;
 	fscanf(fp, "%d", &numLines);
 	printf("There are %d lines in this file\n",numLines);
 
 	printf("opening file to write\n");
 	
 
 	FILE *pFile;
 	pFile = fopen("output.txt", "w");
 
 	if (!pFile)
 	{
 		printf("Error writing maze solution\n");
 		exit(0);
 	}
 	
 	for (int i = 1; i <= numLines; i++)
 	{
 		//read line
 		int limit;
 		
 		fscanf(fp, "%d", &limit);
 		printf("%d   ", limit);
 		while (!isTidyNumber(limit))
 		{
 			limit = limit - 1;
 		}
 
 		printf("%d\n", limit);
 
 		fprintf(pFile, "Case #%d: %d\n", i, limit);
 	}
 
 	//close all files
 	if (fclose(pFile) != 0)
 	{
 		printf("Error closing output file\n");
 		exit(0);
 	}
 	if (fclose(fp) != 0)
 	{
 		printf("Error closing file");
 	}
 	
 	
 	
 	//while (!isTidyNumber(limit))
 	//{
 	//	limit = limit - 1;
 	//}
 
 	//printf("%d", limit);
 			
 }