#include <stdlib.h>
 #include <stdio.h>
 #include <string.h>
 
 // solver: places tidiest number into input string
 void max_tidy(char* input);
 
 // main function
 int main(int argc, char* argv[]) {
   // read in instance count
   int instance_ct = 0;
   scanf("%d ", &instance_ct);
 
   // process all instances
   char inputStr[33];
   for(int i = 1; i <= instance_ct; i++) {
     // read in input string
     scanf("%32s ", inputStr);
 
     // solve instance
     max_tidy(inputStr);
 
     // print prefix
     printf("Case #%d: ", i);
 
     // print answer without leading zeroes
     char* leading = &inputStr[0];
     while(*leading == '0') {
       leading++;
     }
 
     // make sure to print 0, if it is somehow the answer
     if(*leading == 0) {
       printf("0\n");
     } else {
       printf("%s\n", leading);
     }
   }
 
   // return success
   return 0;
 }
 
 // solver: places tidiest number into input string
 void max_tidy(char* input) {
   // special case: skip empty strings
   if(*input == 0)
     return;
 
   // otherwise: find the first out-of-order pair
   for(char* curr = input; *(curr+1) != 0; curr++) {
     // check for out-of-order characters
     if(*curr > *(curr+1)) {
       // find the leftmost character equal to the current
       while(curr > input && *(curr-1) == *curr) {
         curr--;
       }
 
       // decrement this character (can be assumed greater than zero)
       (*curr)--;
 
       // set all remaining characters as highly as possible
       for(curr++; *curr; curr++) {
         *curr = '9';
       }
     }
   }
 }
 
