#include <stdio.h>
 #include <stdlib.h>
 
 #define LINE_INIT_LEN 64
 #define MULTIPLICATOR 2
 
 int readFullLine(char *line) {
     int c;
     int initLen = LINE_INIT_LEN;
     int len = 0;
 
     if(!line) {
         return -1;
     }
 
     while(((c = getc(stdin)) != EOF) && c != '\n') {
 
         if(len >= (initLen - 1)) {
             initLen *= MULTIPLICATOR;
             line = (char*) realloc(line, sizeof(char) * initLen);
             if(!line) {
                 return -1;
             }
 
         }
         line[len++] = (char) c;
     }
     line[len] = '\0';
 
     return len;
 }
 
 
 int compute(char *string, int position, int origin) {
 	int ret = 0;
     int tmp;
 
 	if(!position)
 		return 1;
 
 	while(string[position] < string[position - 1]) {
 		if(string[position] == '0') {
             string[position - 1]--;
 
             tmp = position;
             while(tmp <= origin)
                 string[tmp++] = '9';
 
             ret = compute(string, position - 1, origin);
 		}
         else
             string[position]--;
 	}
 
 	if(!ret)
         return compute(string, position - 1, origin);
 
 	return 1;
 }
 
 
 int main () {
 	int T;
 	char *input;
 	int len;
     char *out;
     int index;
 
         scanf("%d\n", &T);
 
 	for(int i = 1; i <= T; i++) {
         input = (char*) malloc(sizeof(char) * LINE_INIT_LEN);
 
 		len = readFullLine(input);
 
         compute(input, len - 1, len - 1);
 
         index = 0;
         while(input[index] == '0') index++;
         out = &input[index];
 
         printf("Case #%d: %s\n", i, out);
 
 		free(input);
 	}
 
 	return 0;
 }
