#include <stdio.h>
 #include <stdbool.h>
 #include <stdlib.h>
 
 bool IsTidy(unsigned long n) {
     int digit = n % 10;
     int temp;
     n /= 10;
 
     while (n != 0) {
         temp = n % 10;
 
         if (temp > digit)
             return false;
 
         digit = temp;
         n /= 10;
     }
 
     return true;
 }
 
 int NumberToArray(int* numberString, unsigned long n) {
     int digit;
     int idx = 0;
     int tempDigs[18];
 
     while (n > 0) {
         digit = n % 10;
         tempDigs[idx++] = digit;
         n /= 10;
     }
 
     for (int i = 0; i < idx; i++) {
         numberString[idx - 1 - i] = tempDigs[i];
     }
 
     return idx;
 }
 
 unsigned long ArrayToNumber(int* numberString, int lastIdx) {
     unsigned long res = 0;
 
     for (int i = 0; i < lastIdx; i++) {
         res *= 10;
         res += numberString[i];
     }
 
     return res;
 }
 
 void SetNine(int* numberString, int min, int max) {
     for (int i = min; i <= max; i++) {
         numberString[i] = 9;
     }
 }
 
 int main(int argc, char* argv[]) {
     int t;
     unsigned long n;
     int numberString[19];
     int lastIdx;
 
     scanf("%d ", &t);
 
     for (int i = 0; i < t; i++) {
         scanf("%lu ", &n);
         lastIdx = NumberToArray(numberString, n);
 
         for (int j = lastIdx - 1; j > -1; j--) {
             if (j > 0) {
                 if (numberString[j - 1] > numberString[j]) {
                     numberString[j - 1]--;
                     SetNine(numberString, j, lastIdx - 1);
                 }
             }
         }
 
         printf("Case #%d: %lu\n", i + 1, ArrayToNumber(numberString, lastIdx));
     }
 
     return 0;
 }
