#include <stdio.h>
 #include <string.h>
 
 void solve(char *s);
 void adjust(char *s, int start);
 void minus(char *s, int start);
 
 int main(int argc, char *argv[]) {
   FILE *in = fopen("tidy-numbers-large.in", "r");
   FILE *out = fopen("tidy-numbers.out", "w");
 
   int t;
   fscanf(in, "%d", &t);
   for (int i = 1; i <= t; i++) {
     char s[19];
     fscanf(in, "%s", s);
     solve(s);
     char *outs = s;
     while (*outs && *outs == '0') outs++; //remove leading zeroes
     fprintf(out, "Case #%d: %s\n", i, outs);
   }
 
   fclose(in);
   fclose(out);
 
   return 0;
 }
 
 void solve(char *s) {
   int largest = 0;
   for (int i = 0; i < strlen(s); i++) {
     int current = s[i] - '0';
     if (current < largest) {
       adjust(s, i);
     }
     largest = current;
   }
 }
 
 void adjust(char *s, int start) {
   for (int i = start; i < strlen(s); i++) {
     s[i] = '9';
   }
   minus(s, start - 1);
   int smallest = s[start - 1] - '0';
   for (int i = start - 1; i >= 0; i--) {
     int a = s[i] - '0';
     if (a > smallest) {
       minus(s, i);
       smallest = s[i] - '0';
     }
   }
 }
 
 void minus(char *s, int start) {
   int carry = 1;
   for (int i = start; i >= 0; i--) {
     int a = s[i] - '0';
     if (carry) {
       if (a - 1 <= 0 && i != 0) {
         carry = 1;
         s[i] = '9';
       } else {
         carry = 0;
         s[i] = a - 1 + '0';
         s[i + 1] = '9';
       }
     }
   }
 }
