#include <stdio.h>
 #include <stdint.h>
 
 struct
 violation {
 	/* place of lesser significant violating digits */
 	uint8_t place;
 	/* value of lesser significant violating digits */
 	uint8_t digit;
 };
 
 uint64_t
 pow10(uint64_t p)
 {
 	uint64_t res = 1;
 	int i;
 	for (i = 0; i < p; i++)
 		res *= 10;
 	return (res);
 }
 
 int
 largest_violating_digit(uint64_t i, struct violation *res)
 {
 	int d = 10;
 	int dprev = 0;
 	int dv = 10;
 	int p = 0;
 	int pv = -1;
 	do {
 		dprev = d;
 		d = i % 10;
 		if (dprev < d) {
 			pv = p - 1;
 			dv = dprev;
 		}
 		p++;
 	} while ((i = i / 10) > 0);
 	res->digit = dv;
 	res->place = pv;
 	return (pv);
 }
 
 uint64_t
 find_max_tidy(uint64_t limit)
 {
 	uint64_t target = limit;
 	struct violation vlt;
 	while (largest_violating_digit(target, &vlt) != -1) {
 #ifdef DEBUG
 		printf("%d: %d\n", vlt.place, vlt.digit);
 #endif
 		target = target - (target % pow10(vlt.place) + 1);
 	}
 	return (target);
 }
 
 int
 main(int argc, char **argv)
 {
 	//printf("%d\n", violating_digit(12435));
 	int datac = 0;
 	uint64_t n = 0;
 	int i;
 	scanf("%d", &datac);
 	for (i = 0; i < datac; i++) {
 		scanf("%lld", &n);
 		printf("Case #%d: %lld\n", i + 1, find_max_tidy(n));
 	}
 	return (0);
 	//printf("%lld\n", find_max_tidy(111111111111111110));
 	//struct violation v;
 	//largest_violating_digit(1000, &v);
 	//printf("%d: %d\n", v.place, v.digit);
 }
