#include <stdio.h>
 #include <stdbool.h>
 #include <math.h>
 
 #define MAXNUMBERVALUE 1000000000000000000
 #define MAXTESTCASES 100
 #define MAXPLACES 19
 
 int numberToArray(long num, int *numArr) {
    int numPlaces = MAXPLACES;
    for (long i = MAXNUMBERVALUE; i > 0 ; i = i / 10, numPlaces = numPlaces - 1) {
       if (num >= i)
          break;
    }
    long curLeft = num;
    long numInPlace = 0;
    int j = 0;
    for (long i = powl(10, numPlaces-1); i > 0; i = i / 10)
    {
       numInPlace = curLeft / i;
       curLeft = curLeft - (numInPlace*i);
       numArr[j] = numInPlace;
       j = j + 1;
    }
 /*
    for (j = 0; j < numPlaces; j = j + 1) {
       printf("%i ", numArr[j]);
    }
 */
    return numPlaces;
 }
 
 long arrayToNumber(int *numArr, int numPlaces) {
    long num = 0;
    for (int i = 0, j = numPlaces-1; i < numPlaces; i = i + 1, j = j - 1) {
       num = num + (numArr[i]*powl(10,j));
    }
    return num;
 }
 
 int main(void) {
    long inpNum = 0;
    long numTestCases = 0;
    int numArr[MAXPLACES+1];
    //fgets(inpBuff, sizeof(char)*MAXINPUT, stdin);
 
    // Get the number of test cases
    scanf("%ld", &inpNum);
    numTestCases = inpNum;
    if (numTestCases < 1) {
       printf("ERROR: less than 1 test case specified\n");
       return -1;
    }
    else if (numTestCases > MAXTESTCASES) {
       printf("ERROR: more than %i test cases specified\n", MAXTESTCASES);
       return -2;
    }
 
    long inpMulti = 0;
    long curNum = 0;
    long numInPlace = 0;
    int numPlaces;
    for (long i = 0; i < numTestCases; i++) {
       // Initialize seen numbers array
       scanf("%ld", &inpNum);
       printf("Case #%ld: ", i+1);
       if (inpNum > MAXNUMBERVALUE) {
          printf("ERROR - larger than allowed value of %ld\n", MAXNUMBERVALUE);
          continue;
       }
       else if (inpNum < 1) {
          printf("ERROR - less than 1\n");
          continue;
       }
       numPlaces = numberToArray(inpNum, numArr);
       int lastNum = 0;
       int nonTidyStart = -1; // Check at least once
       while (nonTidyStart != 0)
       {
          lastNum = numArr[0];
          nonTidyStart = 0;
          for (int j = 1; j < numPlaces; j = j + 1) {
             if (numArr[j] < lastNum) {
                nonTidyStart = j;
                break;
             }
             lastNum = numArr[j];
          }
          if (nonTidyStart == 0) {
             printf("%ld\n", arrayToNumber(numArr, numPlaces));
          }
          else {
             //printf("Non-tidy start at position %i\n", nonTidyStart);
             numArr[nonTidyStart-1] = lastNum-1;
             for (int j = nonTidyStart; j < numPlaces; j = j + 1) {
                numArr[j] = 9;
             }
             long newNum = arrayToNumber(numArr, numPlaces); 
             //printf("New number: %ld\n", newNum);
 	    numPlaces = numberToArray(newNum, numArr); 
          }
       } 
    }
    return 0;
 }
