#include <stdio.h>
 #include <cmath>
 
 using namespace std;
 
 void asarray(long long x, int arr[], int size)
 {
     for ( int i = (size - 1); i >= 0; --i ) {
         arr[i] = x % 10;
         x /= 10;
     }
 }
 
 
 bool isasc(long long x)
 {
     int last = x % 10,
         curr;
 
     x /= 10;
 
     while ( x != 0 ) {
         curr = x % 10;
         x /= 10;
 
         if (curr > last)
             return false;
 
         last = curr;
     }
 
     return true;
 }
 
 int pos_inc(int arr[], int size)
 {
     for ( int i = 0; i < (size - 1); ++i ) {
         if ( arr[i] >= arr[i + 1] ) {
             return i;
         }
     }
 
     return -1;
 }
 
 long long get_dec(int arr[], int size, int target)
 {
     long long acc = 0;
     long long prod = 1;
 
     for ( int i = (size - 1); i > target; --i ) {
         acc += arr[i] * prod;
         prod *= 10;
     }
 
     return acc + 1;
 }
 
 long long get_top(long long x)
 {
     int size = log10(x) + 1;
     int digits[size];
     int inc = -1;
 
     asarray(x, digits, size);
     inc = pos_inc(digits, size);
 
     if ( inc < 0 ) {
         while ( x > 1 && !isasc(x) ) {
             x--;
         }
     }
     else {
         x -= get_dec(digits, size, inc);
     }
 
     return x;
 }
 
 int main()
 {
     int t = 0;
     long long a;
 
     scanf("%d", &t);
 
     long long answers[t];
 
     for ( int i = 0; i < t; ++i ) {
         scanf("%lld", &a);
         answers[i] = get_top(a);
     }
 
     for ( int i = 0; i < t; ++i ) {
         printf("Case #%d: %lld\n", i+1, answers[i]);
     }
 
     return 0;
 }