#include <stdio.h>
 #include <stdlib.h>
 #include <stdint.h>
 #define  BASE 10
 
 char isTidy(uint64_t n)
 {
 	char num = n % BASE;
 
 	while(n != 0) {
 		if((n % BASE) > num)
 			return 0;
 
 		num = n % BASE;
 		n   = n / BASE;
 	}
 
 	return 1;
 }
 
 /**
  * If number is tidy > we're good
  * If number is not tidy:
  * Decrement until it's tidy
  * > It will always end with 9 (BASE - 1)
  * > [tidy] 9
  * repeat with (number / BASE) - 1
  *
  * eg:
  * f(132) > not tidy, f(12) * 10 + 9
  * f(12) > tidy, 12 * 10 + 9 = 129
  */
 uint64_t solve(uint64_t in)
 {
 	if(isTidy(in))
 		return in;
 
 	return solve((in / BASE) - 1) * BASE + (BASE - 1);
 }
 
 int main(int argc, char *argv[])
 {
 	size_t i, n;
 	uint64_t in;
 
 	scanf("%u", &n);
 
 	for(i = 0; i < n; i++) {
 		scanf("%llu", &in);
 		printf("Case #%d: ", i + 1);
 		printf("%llu\n", solve(in));
 	}
 	
 	return EXIT_SUCCESS;
 }