#include <stdio.h>
 #include <stdlib.h>
 #include <string.h>
 
 #define MAX_LENGTH 1000
 
 int main(int argc, char *argv[]) {
     if (argc < 2) {
         printf("Usage: %s <input-file>\n", argv[0]);
         exit(1);
     }
 
     FILE *fp;
     fp = fopen(argv[1], "r");
 
     int num_examples;
     fscanf(fp, "%d", &num_examples);
 
     for (int i = 0; i < num_examples; i++) {
         printf("Case #%d: ", i+1);
 
         char *input;
         fscanf(fp, "%ms", &input);
         char *buf = input;
 
         int len = strlen(buf);
 
         int j = 1;
         while (j < len) {
             char *a = buf + j - 1;
             char *b = buf + j;
             if (*a <= *b) {
                 j++;
                 continue;
             }
 
             if (a == buf && *a == '1') {
                 *a = ' ';
             } else {
                 *a -= 1;
             }
             memset(b, '9', len-j);
             int k = j-1;
             while (k > 0) {
                 char *c = buf + k - 1;
                 char *d = buf + k;
                 if (*c <= *d) {
                     break;
                 }
 
                 if (c == buf && *c == '1') {
                     *c = ' ';
                 } else {
                     *c = *d;
                 }
                 *d = '9';
                 k--;
             }
         }
 
         while (*buf == ' ') {
             buf++;
         }
 
         printf("%s\n", buf);
 
         free(input);
     }
 
     fclose(fp);
 }
