#include <stdio.h>  // FILE stderr fopen fclose fprintf printf fgets
 #include <stdlib.h> // exit malloc free atoi abs
 #include <math.h> // lround
 #include <string.h>
 
 int tidy(char *number, int index) {
   if (strlen(number) == index+1)
     return 0;
   if (number[index] > number[index+1]) {
     number[index] = number[index]-1;
     for (int i = index+1; i < strlen(number); i++)
     number[i] = '9';
   }
   tidy(number,index+1);
   if (number[index] > number[index+1]) {
     number[index] = number[index]-1;
     number[index+1] = '9';
   }
   return 0;
 }
 
 int main(int argc, char const *argv[])
 {
   // A stream for getting data from the user.
   FILE *in = fopen(argv[1], "r");
   if (!in) { fprintf(stderr, "Can't open %s for reading\n", argv[1]); exit(-1); }
   FILE *out = fopen("output","w");
   if (!out) { fprintf(stderr, "Can't open output for writing\n"); exit(-2); }
   int num_cases;
   fscanf(in, "%d\n", &num_cases);
 
   for (int i = 1; i <= num_cases; ++i)
   {
     char result[80];
     fscanf(in,"%s\n",result);
 
     tidy(result,0);
 
     fprintf(out, "Case #%d: %ld\n", i, atol(result));
   }
 
   fclose(in);
   fclose(out);
 
   return 0;
 }
