﻿/*
 Problem
 
 Tatiana likes to keep things tidy. Her toys are sorted from smallest to largest, her pencils are sorted from shortest to longest and her computers from oldest to newest. One day, when practicing her counting skills, she noticed that some integers, when written in base 10 with no leading zeroes, have their digits sorted in non-decreasing order. Some examples of this are 8, 123, 555, and 224488. She decided to call these numbers tidy. Numbers that do not have this property, like 20, 321, 495 and 999990, are not tidy.
 
 She just finished counting all positive integers in ascending order from 1 to N. What was the last tidy number she counted?
 
 Input
 
 The first line of the input gives the number of test cases, T. T lines follow. Each line describes a test case with a single integer N, the last number counted by Tatiana.
 
 Output
 
 For each test case, output one line containing Case #x: y, where x is the test case number (starting from 1) and y is the last tidy number counted by Tatiana.
 
 Limits
 
 1 ≤ T ≤ 100.
 Small dataset
 
 1 ≤ N ≤ 1000.
 Large dataset
 
 1 ≤ N ≤ 1018.
 Sample
 
 
 Input
 
 Output
 
 4
 132
 1000
 7
 111111111111111110
 
 Case #1: 129
 Case #2: 999
 Case #3: 7
 Case #4: 99999999999999999
 */
 
 #include <iostream>
 #include <vector>
 #include <string>
 #include <fstream>
 
 using namespace std;
 
 
 bool TidyNum(unsigned long long int n){
 	//char s[10];
 
 	string s = to_string(n);
 	//itoa(n,s,10);
 	bool tidy = true;
 
 	for (int i = 0; i < s.length(); i++){
 		
 		for (int j = i; j < s.length(); j++){
 			if (s[i] > s[j]){
 				tidy = false;
 			}
 		}
 	}
 
 
 	return tidy;
 	
 
 
 }
 
 
 unsigned long long int LargestTidy(unsigned long long int n){
 
 	for (unsigned long long int i = n; i > 0; i--){
 		if (TidyNum(i)){
 			return i;
 		}
 	}
 
 }
 
 
 int main(){
 	unsigned long long int n;
 	ifstream in("B-small-attempt1.in");
 	ofstream out("B-small-attempt1.out");
 	int T;
 	in >> T;
 
 	for (int i = 0; i < T; i++){
 		in >> n;
 
 		out << "Case #" << i + 1 << ": " <<LargestTidy(n)<< endl;
 	}
 
 
 	/*while (1){
 		cin >> n;
 		cout<<n<<endl;
 		cout << TidyNum(n) << endl;
 	}*/
 	
 
 	
 	
 
 
 	system("pause");
 	return 0;
 }