#include <sstream>
 #include <fstream>
 #include <string>
 
 #include <algorithm>
 #include <iostream>
 #include <vector>
 
 int64_t ipow(int64_t base, int64_t exp)
 {
     int64_t result = 1;
     while (exp)
     {
         if (exp & 1)
             result *= base;
         exp >>= 1;
         base *= base;
     }
 
     return result;
 }
 
 int main(int argc, char**argv){
 
     if(argc != 2){
         std::cout << "Pass the filename" << std::endl;
         return 0;
     }
 
     std::string line;
     std::ifstream infile(argv[1]);
 
     int case_ = 0;
     std::getline(infile,line); // discard number of cases
 
 
     while (std::getline(infile, line))  // this does the checking!
     {
         std::istringstream iss(line);
         int K = 0, // length of tile sequence
             C = 0, // complexity of seq
             S = 0; // number of tiles to look at
         
         iss >> K ; iss >> C ; iss >> S;
 
         std::cout << "Case #" << ++case_ << ":" ;
         if(C==1){
             if(S>=K){
                 for(int i=1; i <= S; ++i) std::cout << ' ' << i;
             }
             else std::cout << " IMPOSSIBLE";
             
             std::cout << std::endl;
             continue;
         }
         if(K==1){
             if(S>=1) std::cout << " 1 ";
             else std::cout << " IMPOSSIBLE";
             std::cout << std::endl;
             continue;
         }
         if( S < (K+1)/2 ) std::cout << " IMPOSSIBLE";
         else{
             int64_t offset = 0;
             int64_t indexWithinBlock = 0;
             for(int n = 0; n < K/2; ++n){
                 offset = 2*n*ipow(K,C-1);
                 indexWithinBlock = 2*(n+1)*ipow(K,C-2);
                 std::cout << " " << offset + indexWithinBlock;
             }
             if(K%2 == 1){ 
                 std::cout << " " << ipow(K,C) -  1; // in case of odd number we also need to look at the last one
             }
         }
         std::cout << std::endl;
     }
     return 0;
 }
