#include <iostream>
 #include <cassert>
 
 int main()
 {
   int cases = 0;
   std::cin >> cases;
 
   for (int i = 1; i <= cases; ++i) {
     int k = 0;
     int c = 0;
     int s = 0;
 
     std::cin >> k >> c >> s;
 
     assert (s <= k);
 
     // First we deal with the corner cases of k==1 (single tile) and c==1 (just the original
     // sequence, no redundancy, need to check all tiles).
     // If k>1 and c>1, the first tile in the original sequence is either L or G.
     // If it's L, the first K tiles of the artwork always contain the original sequence.
     // If it's G, they always contain all Gs. The first bit of information is thus redundant;
     // i.e., we can use the K-1 tiles 2..K to decide whether the original has any Gs,
     // which is true iff the entire artwork has any Gs.
     std::cout << "Case #" << i << ':';
     if (k == 1) {
       std::cout << " 1";
     }
     else if (c == 1) { // no redundancy, need to check all tiles
       if (s < k) {
 	std::cout << " IMPOSSIBLE";
       }
       else {
 	for (int j = 1; j <= k; ++j) {
 	  std::cout << ' ' << j;
 	}
       }
     }
     else if (s < k - 1) {
       std::cout << " IMPOSSIBLE";
     }
     else {
       for (int j = 2; j <= k; ++j) {
 	std::cout << ' ' << j;
       }
     }
     std::cout << std::endl;
   }
   
   return 0;
 }
