#include <iostream>
 #include <vector>
 #include <cmath>
 
 using namespace std;
 
 vector<__int128> fractile(int k, int c, int s);
 
 int main(){
     
     int numOfTest = 0;
     int count = 0;
     string line;
 
     if(getline(cin, line)){
         numOfTest = stoi(line);
     }
     else{
         cout << "No testcase is specified.\n";
         return 1;
     }
 
     while(getline(cin, line)) {
 
         string::size_type sz1;
         string::size_type sz2;
         int k = stoi(line, &sz1);
         int c = stoi(line.substr(sz1), &sz2);
         int s = stoi(line.substr(sz1 + sz2));
 
         // cout << "Debug: " << k << ", " << c << ", " << s << endl;
 
         vector<__int128> result = fractile(k, c, s);
         cout << "Case #" << ++count << ":";
 
         int size = result.size();
         if(size){
             for(int i = 0; i < size; i++){
                 //cout << " " << result[i];
                 printf(" %llu", result[i]);
             }
             cout << endl;
         }
         else{
             cout << " IMPOSSIBLE" << endl;
         }
     }
 
     return 0;
 
 }
 
 vector<__int128> fractile(int k, int c, int s){
     vector<__int128> ans;
 
     if(c == 1 && s < k){
         return ans;
     }
     else if(s >= k){
         for(int i = 0; i < k; i++){
             ans.push_back(i+1);
         }
         return ans;
     }
 
     if( s < k/2 )
         return ans;
 
     /* For small testcases */
     /*
     for(int i = 2; i < k; i++){
         ans.push_back(i);
     }
     */
 
     /* For larger testcases */
     double dOffset = pow(k, c-1);
     __int128 iOffset = (__int128)dOffset;
     __int128 temp = 2;
     for(int i = 0; i < s; i++){
         ans.push_back(temp);
         temp += ((2*iOffset) + 2);
     }
 
     return ans;
 }
